//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armfeatures_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armfeatures"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0cc5e2efd6ffccf30e80d1e150b488dd87198b94/specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/listSubscriptionFeatures.json
func ExampleClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfeatures.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListAllPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FeatureOperationsListResult = armfeatures.FeatureOperationsListResult{
		// 	Value: []*armfeatures.FeatureResult{
		// 		{
		// 			Name: to.Ptr("Feature1"),
		// 			Type: to.Ptr("type1"),
		// 			ID: to.Ptr("feature_id1"),
		// 			Properties: &armfeatures.FeatureProperties{
		// 				State: to.Ptr("registered"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Feature2"),
		// 			Type: to.Ptr("type2"),
		// 			ID: to.Ptr("feature_id2"),
		// 			Properties: &armfeatures.FeatureProperties{
		// 				State: to.Ptr("unregistered"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0cc5e2efd6ffccf30e80d1e150b488dd87198b94/specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/listProviderFeatures.json
func ExampleClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfeatures.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListPager("Resource Provider Namespace", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.FeatureOperationsListResult = armfeatures.FeatureOperationsListResult{
		// 	Value: []*armfeatures.FeatureResult{
		// 		{
		// 			Name: to.Ptr("Feature1"),
		// 			Type: to.Ptr("type1"),
		// 			ID: to.Ptr("feature_id1"),
		// 			Properties: &armfeatures.FeatureProperties{
		// 				State: to.Ptr("registered"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Feature2"),
		// 			Type: to.Ptr("type2"),
		// 			ID: to.Ptr("feature_id2"),
		// 			Properties: &armfeatures.FeatureProperties{
		// 				State: to.Ptr("unregistered"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0cc5e2efd6ffccf30e80d1e150b488dd87198b94/specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/getFeature.json
func ExampleClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfeatures.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Get(ctx, "Resource Provider Namespace", "feature", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FeatureResult = armfeatures.FeatureResult{
	// 	Name: to.Ptr("Feature1"),
	// 	Type: to.Ptr("type1"),
	// 	ID: to.Ptr("feature_id1"),
	// 	Properties: &armfeatures.FeatureProperties{
	// 		State: to.Ptr("registered"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0cc5e2efd6ffccf30e80d1e150b488dd87198b94/specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/registerFeature.json
func ExampleClient_Register() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfeatures.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Register(ctx, "Resource Provider Namespace", "feature", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FeatureResult = armfeatures.FeatureResult{
	// 	Name: to.Ptr("Feature1"),
	// 	Type: to.Ptr("type1"),
	// 	ID: to.Ptr("feature_id1"),
	// 	Properties: &armfeatures.FeatureProperties{
	// 		State: to.Ptr("registered"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/0cc5e2efd6ffccf30e80d1e150b488dd87198b94/specification/resources/resource-manager/Microsoft.Features/stable/2021-07-01/examples/unregisterFeature.json
func ExampleClient_Unregister() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfeatures.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().Unregister(ctx, "Resource Provider Namespace", "feature", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FeatureResult = armfeatures.FeatureResult{
	// 	Name: to.Ptr("Feature1"),
	// 	Type: to.Ptr("Microsoft.Features/providers/features"),
	// 	ID: to.Ptr("/subscriptions/ff23096b-f5a2-46ea-bd62-59c3e93fef9a/providers/Microsoft.Features/providers/Microsoft.Test/features/Feature1"),
	// 	Properties: &armfeatures.FeatureProperties{
	// 		State: to.Ptr("unregistered"),
	// 	},
	// }
}
