//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// JobStepsServer is a fake server for instances of the armsql.JobStepsClient type.
type JobStepsServer struct {
	// CreateOrUpdate is the fake for method JobStepsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string, parameters armsql.JobStep, options *armsql.JobStepsClientCreateOrUpdateOptions) (resp azfake.Responder[armsql.JobStepsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method JobStepsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string, options *armsql.JobStepsClientDeleteOptions) (resp azfake.Responder[armsql.JobStepsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method JobStepsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, stepName string, options *armsql.JobStepsClientGetOptions) (resp azfake.Responder[armsql.JobStepsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByVersion is the fake for method JobStepsClient.GetByVersion
	// HTTP status codes to indicate success: http.StatusOK
	GetByVersion func(ctx context.Context, resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32, stepName string, options *armsql.JobStepsClientGetByVersionOptions) (resp azfake.Responder[armsql.JobStepsClientGetByVersionResponse], errResp azfake.ErrorResponder)

	// NewListByJobPager is the fake for method JobStepsClient.NewListByJobPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByJobPager func(resourceGroupName string, serverName string, jobAgentName string, jobName string, options *armsql.JobStepsClientListByJobOptions) (resp azfake.PagerResponder[armsql.JobStepsClientListByJobResponse])

	// NewListByVersionPager is the fake for method JobStepsClient.NewListByVersionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByVersionPager func(resourceGroupName string, serverName string, jobAgentName string, jobName string, jobVersion int32, options *armsql.JobStepsClientListByVersionOptions) (resp azfake.PagerResponder[armsql.JobStepsClientListByVersionResponse])
}

// NewJobStepsServerTransport creates a new instance of JobStepsServerTransport with the provided implementation.
// The returned JobStepsServerTransport instance is connected to an instance of armsql.JobStepsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewJobStepsServerTransport(srv *JobStepsServer) *JobStepsServerTransport {
	return &JobStepsServerTransport{
		srv:                   srv,
		newListByJobPager:     newTracker[azfake.PagerResponder[armsql.JobStepsClientListByJobResponse]](),
		newListByVersionPager: newTracker[azfake.PagerResponder[armsql.JobStepsClientListByVersionResponse]](),
	}
}

// JobStepsServerTransport connects instances of armsql.JobStepsClient to instances of JobStepsServer.
// Don't use this type directly, use NewJobStepsServerTransport instead.
type JobStepsServerTransport struct {
	srv                   *JobStepsServer
	newListByJobPager     *tracker[azfake.PagerResponder[armsql.JobStepsClientListByJobResponse]]
	newListByVersionPager *tracker[azfake.PagerResponder[armsql.JobStepsClientListByVersionResponse]]
}

// Do implements the policy.Transporter interface for JobStepsServerTransport.
func (j *JobStepsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "JobStepsClient.CreateOrUpdate":
		resp, err = j.dispatchCreateOrUpdate(req)
	case "JobStepsClient.Delete":
		resp, err = j.dispatchDelete(req)
	case "JobStepsClient.Get":
		resp, err = j.dispatchGet(req)
	case "JobStepsClient.GetByVersion":
		resp, err = j.dispatchGetByVersion(req)
	case "JobStepsClient.NewListByJobPager":
		resp, err = j.dispatchNewListByJobPager(req)
	case "JobStepsClient.NewListByVersionPager":
		resp, err = j.dispatchNewListByVersionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (j *JobStepsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if j.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobAgents/(?P<jobAgentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/steps/(?P<stepName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsql.JobStep](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	jobAgentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobAgentName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	stepNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("stepName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, jobAgentNameParam, jobNameParam, stepNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobStep, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JobStepsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if j.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobAgents/(?P<jobAgentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/steps/(?P<stepName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	jobAgentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobAgentName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	stepNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("stepName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Delete(req.Context(), resourceGroupNameParam, serverNameParam, jobAgentNameParam, jobNameParam, stepNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JobStepsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if j.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobAgents/(?P<jobAgentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/steps/(?P<stepName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	jobAgentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobAgentName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	stepNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("stepName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, jobAgentNameParam, jobNameParam, stepNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobStep, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JobStepsServerTransport) dispatchGetByVersion(req *http.Request) (*http.Response, error) {
	if j.srv.GetByVersion == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByVersion not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobAgents/(?P<jobAgentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<jobVersion>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/steps/(?P<stepName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	jobAgentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobAgentName")])
	if err != nil {
		return nil, err
	}
	jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
	if err != nil {
		return nil, err
	}
	jobVersionUnescaped, err := url.PathUnescape(matches[regex.SubexpIndex("jobVersion")])
	if err != nil {
		return nil, err
	}
	jobVersionParam, err := parseWithCast(jobVersionUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	stepNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("stepName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.GetByVersion(req.Context(), resourceGroupNameParam, serverNameParam, jobAgentNameParam, jobNameParam, jobVersionParam, stepNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JobStep, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JobStepsServerTransport) dispatchNewListByJobPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByJobPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByJobPager not implemented")}
	}
	newListByJobPager := j.newListByJobPager.get(req)
	if newListByJobPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobAgents/(?P<jobAgentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/steps`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		jobAgentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobAgentName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		resp := j.srv.NewListByJobPager(resourceGroupNameParam, serverNameParam, jobAgentNameParam, jobNameParam, nil)
		newListByJobPager = &resp
		j.newListByJobPager.add(req, newListByJobPager)
		server.PagerResponderInjectNextLinks(newListByJobPager, req, func(page *armsql.JobStepsClientListByJobResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByJobPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByJobPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByJobPager) {
		j.newListByJobPager.remove(req)
	}
	return resp, nil
}

func (j *JobStepsServerTransport) dispatchNewListByVersionPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListByVersionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByVersionPager not implemented")}
	}
	newListByVersionPager := j.newListByVersionPager.get(req)
	if newListByVersionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobAgents/(?P<jobAgentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/jobs/(?P<jobName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/versions/(?P<jobVersion>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/steps`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		jobAgentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobAgentName")])
		if err != nil {
			return nil, err
		}
		jobNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("jobName")])
		if err != nil {
			return nil, err
		}
		jobVersionUnescaped, err := url.PathUnescape(matches[regex.SubexpIndex("jobVersion")])
		if err != nil {
			return nil, err
		}
		jobVersionParam, err := parseWithCast(jobVersionUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := j.srv.NewListByVersionPager(resourceGroupNameParam, serverNameParam, jobAgentNameParam, jobNameParam, jobVersionParam, nil)
		newListByVersionPager = &resp
		j.newListByVersionPager.add(req, newListByVersionPager)
		server.PagerResponderInjectNextLinks(newListByVersionPager, req, func(page *armsql.JobStepsClientListByVersionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByVersionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListByVersionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByVersionPager) {
		j.newListByVersionPager.remove(req)
	}
	return resp, nil
}
