//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sqlvirtualmachine/armsqlvirtualmachine"
	"net/http"
	"net/url"
	"regexp"
)

// TroubleshootServer is a fake server for instances of the armsqlvirtualmachine.TroubleshootClient type.
type TroubleshootServer struct {
	// BeginTroubleshoot is the fake for method TroubleshootClient.BeginTroubleshoot
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTroubleshoot func(ctx context.Context, resourceGroupName string, sqlVirtualMachineName string, parameters armsqlvirtualmachine.SQLVMTroubleshooting, options *armsqlvirtualmachine.TroubleshootClientBeginTroubleshootOptions) (resp azfake.PollerResponder[armsqlvirtualmachine.TroubleshootClientTroubleshootResponse], errResp azfake.ErrorResponder)
}

// NewTroubleshootServerTransport creates a new instance of TroubleshootServerTransport with the provided implementation.
// The returned TroubleshootServerTransport instance is connected to an instance of armsqlvirtualmachine.TroubleshootClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTroubleshootServerTransport(srv *TroubleshootServer) *TroubleshootServerTransport {
	return &TroubleshootServerTransport{
		srv:               srv,
		beginTroubleshoot: newTracker[azfake.PollerResponder[armsqlvirtualmachine.TroubleshootClientTroubleshootResponse]](),
	}
}

// TroubleshootServerTransport connects instances of armsqlvirtualmachine.TroubleshootClient to instances of TroubleshootServer.
// Don't use this type directly, use NewTroubleshootServerTransport instead.
type TroubleshootServerTransport struct {
	srv               *TroubleshootServer
	beginTroubleshoot *tracker[azfake.PollerResponder[armsqlvirtualmachine.TroubleshootClientTroubleshootResponse]]
}

// Do implements the policy.Transporter interface for TroubleshootServerTransport.
func (t *TroubleshootServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TroubleshootClient.BeginTroubleshoot":
		resp, err = t.dispatchBeginTroubleshoot(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TroubleshootServerTransport) dispatchBeginTroubleshoot(req *http.Request) (*http.Response, error) {
	if t.srv.BeginTroubleshoot == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTroubleshoot not implemented")}
	}
	beginTroubleshoot := t.beginTroubleshoot.get(req)
	if beginTroubleshoot == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SqlVirtualMachine/sqlVirtualMachines/(?P<sqlVirtualMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/troubleshoot`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsqlvirtualmachine.SQLVMTroubleshooting](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sqlVirtualMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlVirtualMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginTroubleshoot(req.Context(), resourceGroupNameParam, sqlVirtualMachineNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTroubleshoot = &respr
		t.beginTroubleshoot.add(req, beginTroubleshoot)
	}

	resp, err := server.PollerResponderNext(beginTroubleshoot, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		t.beginTroubleshoot.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTroubleshoot) {
		t.beginTroubleshoot.remove(req)
	}

	return resp, nil
}
