//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsupport

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FilesNoSubscriptionClient contains the methods for the FilesNoSubscription group.
// Don't use this type directly, use NewFilesNoSubscriptionClient() instead.
type FilesNoSubscriptionClient struct {
	internal *arm.Client
}

// NewFilesNoSubscriptionClient creates a new instance of FilesNoSubscriptionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFilesNoSubscriptionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*FilesNoSubscriptionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FilesNoSubscriptionClient{
		internal: cl,
	}
	return client, nil
}

// Create - Creates a new file under a workspace.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-01-preview
//   - fileWorkspaceName - File workspace name.
//   - fileName - File name.
//   - createFileParameters - Create file object
//   - options - FilesNoSubscriptionClientCreateOptions contains the optional parameters for the FilesNoSubscriptionClient.Create
//     method.
func (client *FilesNoSubscriptionClient) Create(ctx context.Context, fileWorkspaceName string, fileName string, createFileParameters FileDetails, options *FilesNoSubscriptionClientCreateOptions) (FilesNoSubscriptionClientCreateResponse, error) {
	var err error
	const operationName = "FilesNoSubscriptionClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, fileWorkspaceName, fileName, createFileParameters, options)
	if err != nil {
		return FilesNoSubscriptionClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FilesNoSubscriptionClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FilesNoSubscriptionClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *FilesNoSubscriptionClient) createCreateRequest(ctx context.Context, fileWorkspaceName string, fileName string, createFileParameters FileDetails, options *FilesNoSubscriptionClientCreateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}"
	if fileWorkspaceName == "" {
		return nil, errors.New("parameter fileWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileWorkspaceName}", url.PathEscape(fileWorkspaceName))
	if fileName == "" {
		return nil, errors.New("parameter fileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileName}", url.PathEscape(fileName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, createFileParameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *FilesNoSubscriptionClient) createHandleResponse(resp *http.Response) (FilesNoSubscriptionClientCreateResponse, error) {
	result := FilesNoSubscriptionClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileDetails); err != nil {
		return FilesNoSubscriptionClientCreateResponse{}, err
	}
	return result, nil
}

// Get - Returns details of a specific file in a work space.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-01-preview
//   - fileWorkspaceName - File Workspace Name
//   - fileName - File Name
//   - options - FilesNoSubscriptionClientGetOptions contains the optional parameters for the FilesNoSubscriptionClient.Get method.
func (client *FilesNoSubscriptionClient) Get(ctx context.Context, fileWorkspaceName string, fileName string, options *FilesNoSubscriptionClientGetOptions) (FilesNoSubscriptionClientGetResponse, error) {
	var err error
	const operationName = "FilesNoSubscriptionClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, fileWorkspaceName, fileName, options)
	if err != nil {
		return FilesNoSubscriptionClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FilesNoSubscriptionClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FilesNoSubscriptionClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *FilesNoSubscriptionClient) getCreateRequest(ctx context.Context, fileWorkspaceName string, fileName string, options *FilesNoSubscriptionClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}"
	if fileWorkspaceName == "" {
		return nil, errors.New("parameter fileWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileWorkspaceName}", url.PathEscape(fileWorkspaceName))
	if fileName == "" {
		return nil, errors.New("parameter fileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileName}", url.PathEscape(fileName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FilesNoSubscriptionClient) getHandleResponse(resp *http.Response) (FilesNoSubscriptionClientGetResponse, error) {
	result := FilesNoSubscriptionClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FileDetails); err != nil {
		return FilesNoSubscriptionClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists all the Files information under a workspace for an Azure subscription.
//
// Generated from API version 2022-09-01-preview
//   - fileWorkspaceName - File Workspace Name
//   - options - FilesNoSubscriptionClientListOptions contains the optional parameters for the FilesNoSubscriptionClient.NewListPager
//     method.
func (client *FilesNoSubscriptionClient) NewListPager(fileWorkspaceName string, options *FilesNoSubscriptionClientListOptions) *runtime.Pager[FilesNoSubscriptionClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FilesNoSubscriptionClientListResponse]{
		More: func(page FilesNoSubscriptionClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FilesNoSubscriptionClientListResponse) (FilesNoSubscriptionClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FilesNoSubscriptionClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, fileWorkspaceName, options)
			}, nil)
			if err != nil {
				return FilesNoSubscriptionClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *FilesNoSubscriptionClient) listCreateRequest(ctx context.Context, fileWorkspaceName string, options *FilesNoSubscriptionClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files"
	if fileWorkspaceName == "" {
		return nil, errors.New("parameter fileWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileWorkspaceName}", url.PathEscape(fileWorkspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *FilesNoSubscriptionClient) listHandleResponse(resp *http.Response) (FilesNoSubscriptionClientListResponse, error) {
	result := FilesNoSubscriptionClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FilesListResult); err != nil {
		return FilesNoSubscriptionClientListResponse{}, err
	}
	return result, nil
}

// Upload - This API allows you to upload content to a file
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-09-01-preview
//   - fileWorkspaceName - File WorkspaceName
//   - fileName - File Name
//   - uploadFile - UploadFile object
//   - options - FilesNoSubscriptionClientUploadOptions contains the optional parameters for the FilesNoSubscriptionClient.Upload
//     method.
func (client *FilesNoSubscriptionClient) Upload(ctx context.Context, fileWorkspaceName string, fileName string, uploadFile UploadFile, options *FilesNoSubscriptionClientUploadOptions) (FilesNoSubscriptionClientUploadResponse, error) {
	var err error
	const operationName = "FilesNoSubscriptionClient.Upload"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.uploadCreateRequest(ctx, fileWorkspaceName, fileName, uploadFile, options)
	if err != nil {
		return FilesNoSubscriptionClientUploadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FilesNoSubscriptionClientUploadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return FilesNoSubscriptionClientUploadResponse{}, err
	}
	return FilesNoSubscriptionClientUploadResponse{}, nil
}

// uploadCreateRequest creates the Upload request.
func (client *FilesNoSubscriptionClient) uploadCreateRequest(ctx context.Context, fileWorkspaceName string, fileName string, uploadFile UploadFile, options *FilesNoSubscriptionClientUploadOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/fileWorkspaces/{fileWorkspaceName}/files/{fileName}/upload"
	if fileWorkspaceName == "" {
		return nil, errors.New("parameter fileWorkspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileWorkspaceName}", url.PathEscape(fileWorkspaceName))
	if fileName == "" {
		return nil, errors.New("parameter fileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{fileName}", url.PathEscape(fileName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, uploadFile); err != nil {
		return nil, err
	}
	return req, nil
}
