//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolPrincipalAssignmentsCheckNameAvailability.json
func ExampleKustoPoolPrincipalAssignmentsClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewKustoPoolPrincipalAssignmentsClient().CheckNameAvailability(ctx, "synapseWorkspaceName", "kustoclusterrptest4", "kustorptest", armsynapse.ClusterPrincipalAssignmentCheckNameRequest{
		Name: to.Ptr("kustoprincipal1"),
		Type: to.Ptr("Microsoft.Synapse/workspaces/kustoPools/principalAssignments"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameResult = armsynapse.CheckNameResult{
	// 	Name: to.Ptr("kustoprincipal1"),
	// 	Message: to.Ptr("Name 'kustoprincipal1' is already taken. Please specify a different name"),
	// 	NameAvailable: to.Ptr(false),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolPrincipalAssignmentsList.json
func ExampleKustoPoolPrincipalAssignmentsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewKustoPoolPrincipalAssignmentsClient().NewListPager("synapseWorkspaceName", "kustoclusterrptest4", "kustorptest", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ClusterPrincipalAssignmentListResult = armsynapse.ClusterPrincipalAssignmentListResult{
		// 	Value: []*armsynapse.ClusterPrincipalAssignment{
		// 		{
		// 			Name: to.Ptr("synapseWorkspaceName/kustoclusterrptest4/kustoprincipal1"),
		// 			Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/PrincipalAssignments"),
		// 			ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/workspaces/synapseWorkspaceName/kustoPools/kustoclusterrptest4/PrincipalAssignments/kustoprincipal1"),
		// 			Properties: &armsynapse.ClusterPrincipalProperties{
		// 				AADObjectID: to.Ptr("98765432-1234-1234-1234-123456789123"),
		// 				PrincipalID: to.Ptr("87654321-1234-1234-1234-123456789123"),
		// 				PrincipalName: to.Ptr("TestApp"),
		// 				PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
		// 				ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
		// 				Role: to.Ptr(armsynapse.ClusterPrincipalRole("Admin")),
		// 				TenantID: to.Ptr("12345678-1234-1234-1234-123456789123"),
		// 				TenantName: to.Ptr("tenantName"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("synapseWorkspaceName/kustoclusterrptest4/kustoprincipal2"),
		// 			Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/PrincipalAssignments"),
		// 			ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/workspaces/synapseWorkspaceName/kustoPools/kustoclusterrptest4/PrincipalAssignments/kustoprincipal2"),
		// 			Properties: &armsynapse.ClusterPrincipalProperties{
		// 				AADObjectID: to.Ptr("98765432-1234-1234-1234-123456789123"),
		// 				PrincipalID: to.Ptr("87654321-1234-1234-1234-123456789123"),
		// 				PrincipalName: to.Ptr("TestApp"),
		// 				PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
		// 				ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
		// 				Role: to.Ptr(armsynapse.ClusterPrincipalRole("Admin")),
		// 				TenantID: to.Ptr("12345678-1234-1234-1234-123456789123"),
		// 				TenantName: to.Ptr("tenantName"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolPrincipalAssignmentsGet.json
func ExampleKustoPoolPrincipalAssignmentsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewKustoPoolPrincipalAssignmentsClient().Get(ctx, "synapseWorkspaceName", "kustoclusterrptest4", "kustoprincipal1", "kustorptest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ClusterPrincipalAssignment = armsynapse.ClusterPrincipalAssignment{
	// 	Name: to.Ptr("synapseWorkspaceName/kustoclusterrptest4/kustoprincipal1"),
	// 	Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/PrincipalAssignments"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/workspaces/synapseWorkspaceName/kustoPools/kustoclusterrptest4/PrincipalAssignments/kustoprincipal1"),
	// 	Properties: &armsynapse.ClusterPrincipalProperties{
	// 		AADObjectID: to.Ptr("98765432-1234-1234-1234-123456789123"),
	// 		PrincipalID: to.Ptr("87654321-1234-1234-1234-123456789123"),
	// 		PrincipalName: to.Ptr("TestApp"),
	// 		PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
	// 		ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
	// 		Role: to.Ptr(armsynapse.ClusterPrincipalRole("Admin")),
	// 		TenantID: to.Ptr("12345678-1234-1234-1234-123456789123"),
	// 		TenantName: to.Ptr("tenantName"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolPrincipalAssignmentsCreateOrUpdate.json
func ExampleKustoPoolPrincipalAssignmentsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewKustoPoolPrincipalAssignmentsClient().BeginCreateOrUpdate(ctx, "synapseWorkspaceName", "kustoclusterrptest4", "kustoprincipal1", "kustorptest", armsynapse.ClusterPrincipalAssignment{
		Properties: &armsynapse.ClusterPrincipalProperties{
			PrincipalID:   to.Ptr("87654321-1234-1234-1234-123456789123"),
			PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
			Role:          to.Ptr(armsynapse.ClusterPrincipalRoleAllDatabasesAdmin),
			TenantID:      to.Ptr("12345678-1234-1234-1234-123456789123"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ClusterPrincipalAssignment = armsynapse.ClusterPrincipalAssignment{
	// 	Name: to.Ptr("synapseWorkspaceName/kustoclusterrptest4/kustoprincipal1"),
	// 	Type: to.Ptr("Microsoft.Synapse/Workspaces/KustoPools/PrincipalAssignments"),
	// 	ID: to.Ptr("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Synapse/workspaces/synapseWorkspaceName/kustoPools/kustoclusterrptest4/PrincipalAssignments/kustoprincipal1"),
	// 	Properties: &armsynapse.ClusterPrincipalProperties{
	// 		AADObjectID: to.Ptr("98765432-1234-1234-1234-123456789123"),
	// 		PrincipalID: to.Ptr("87654321-1234-1234-1234-123456789123"),
	// 		PrincipalName: to.Ptr("TestApp"),
	// 		PrincipalType: to.Ptr(armsynapse.PrincipalTypeApp),
	// 		ProvisioningState: to.Ptr(armsynapse.ResourceProvisioningStateSucceeded),
	// 		Role: to.Ptr(armsynapse.ClusterPrincipalRole("Admin")),
	// 		TenantID: to.Ptr("12345678-1234-1234-1234-123456789123"),
	// 		TenantName: to.Ptr("tenantName"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/preview/2021-06-01-preview/examples/KustoPoolPrincipalAssignmentsDelete.json
func ExampleKustoPoolPrincipalAssignmentsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewKustoPoolPrincipalAssignmentsClient().BeginDelete(ctx, "synapseWorkspaceName", "kustoclusterrptest4", "kustoprincipal1", "kustorptest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
