---
layout: post
title: Polyglot 1.10 - Verbesserungen an i18n_headers
lang: de
description: Jekyll Polyglot 1.10.0 Veröffentlichung mit Verbesserungen an der SEO-Generierung beim Einsatz des i18n_headers-Plugins
---

Jekyll-Polyglot 1.10 ist jetzt verfügbar. Es gibt große Verbesserungen und Änderungen am `i18n_headers` Liquid-Plugin für SEO-Verbesserungen sowie kleinere Anpassungen für die Idempotenz beim parallelen Bauen. Community-Beiträge und Vibe Coding haben einen großen Teil dieser Release-Features, Tests und Blogposts beigesteuert.

## Verbesserungen an i18n_headers

Das `i18n_headers`-Plugin hat in dieser Version erweiterte Fähigkeiten:

* Es fügt für jede Sprachversion einer Seite ein `<link rel="canonical" ...>` hinzu, sodass das Indexieren für jede Seite eindeutig ist.
* Es fügt `<link rel="alternate" hreflang="x-default" ...>` hinzu, um auf die Standardsprachversion einer Seite zu verweisen, wenn keine passende Sprache vom Browser angefordert wird.
* Es definiert `<link rel="alternate" hreflang="...">` korrekt für Seiten und Beiträge in Kollektionen mit benutzerdefinierten Permalinks.
* Die Standard-URL enthält jetzt `site.baseUrl`, falls definiert.

Außerdem wurde ein Fehler behoben, der dazu führte, dass die Relativierung absoluter URLs diese Tags unbeabsichtigt verfälschte.

## Vibe-Coded-Beiträge

Der Einsatz bestimmter [Vibe Coding](https://en.wikipedia.org/wiki/Vibe_coding)-Werkzeuge hat geholfen, Fehler und Features für dieses Release zu finden, zu messen und zu verifizieren. Dies ist ein neuer Ansatz in der Softwareentwicklung und ermöglichte fortschrittliche Ruby-Tests gegen Jekyll-Plugin-Code, der auf vielen gebauten Site-Sprachen läuft.

Die mit Vibe Coding geschriebenen Tests halfen, eine hohe Testabdeckung sicherzustellen und komplexe Features mit Vertrauen zu implementieren. Die Automatisierung der Tests sorgte dafür, dass auch schwierige Features korrekt gebaut werden konnten.

Zusätzlich halfen Vibe Coding Tools, diesen Blogpost in viele Sprachen zu übersetzen.

## Community-Beiträge

Jekyll-Polyglot wird von Menschen unterstützt. Menschliche Sprachdokumentation wird von Menschen beigetragen, die dieses Plugin in ihrer Muttersprache dokumentiert sehen möchten. Menschen, die Fehlerbehebungen und Dokumentation beitragen, haben dazu beigetragen, dass dieses Plugin bei jeder Veröffentlichung tausende Downloads erreicht. KI-gestützte Programmierung, in meinen oder Ihren Händen, wird die Software, die wir nutzen, und die vielen Sprachen, in denen wir schreiben und sprechen, prägen. 

## Ruby >= 3.1 erforderlich

Laufende Sicherheitsupdates für die Build-Abhängigkeiten von jekyll-polyglot machten ein großes Upgrade auf Ruby 3.1 erforderlich. Dies kann Build-Systeme betreffen, die ihre Dokumentation mit jekyll-polyglot erstellen. Jetzt ist ein guter Zeitpunkt, auf die neueste Ruby-Hauptversion zu aktualisieren. Melden Sie sich, falls diese Änderungen Komplikationen beim Jekyll-Build verursachen. 