#![no_main]

use libfuzzer_sys::arbitrary::{Result, Unstructured};
use libfuzzer_sys::fuzz_target;
use wasmtime_fuzzing::{generators, oracles};

fuzz_target!(|data: &[u8]| {
    // errors in `run` have to do with not enough input in `data`, which we
    // ignore here since it doesn't affect how we'd like to fuzz.
    let _ = run_one(data);
});

fn run_one(data: &[u8]) -> Result<()> {
    let mut u = Unstructured::new(data);
    let mut config: generators::Config = u.arbitrary()?;

    // Try to ensure imports/exports/etc are generated by adding one to the
    // minimums/maximums.
    config.module_config.config.min_types = 1;
    config.module_config.config.max_types += 1;
    config.module_config.config.min_imports = 1;
    config.module_config.config.max_imports += 1;
    config.module_config.config.min_funcs = 1;
    config.module_config.config.max_funcs += 1;
    config.module_config.config.min_exports = 1;
    config.module_config.config.max_exports += 1;

    // Use the fuzz input to select an async strategy.
    config.enable_async(&mut u)?;

    let mut poll_amts = Vec::with_capacity(u.arbitrary_len::<u32>()?);
    for _ in 0..poll_amts.capacity() {
        poll_amts.push(u.int_in_range(0..=10_000)?);
    }
    let module = config.module_config.generate(&mut u, None)?;
    oracles::call_async(&module.to_bytes(), &config, &poll_amts);

    Ok(())
}
