/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigInteger;
import spec.jbb.Company;
import spec.jbb.JBButil;

public class Stock {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private String[] district_text;
    private String data;
    private int id;
    private int quantity;
    private BigInteger ytd;
    private short orderCount;
    private short remoteCount;
    private short warehouseId;

    public Stock(Company company, int n, short s) {
        this.initStock(company, n, s);
    }

    public void initStock(Company company, int n, short s) {
        this.quantity = JBButil.random(10, 100, s);
        this.ytd = BigInteger.ZERO;
        this.orderCount = 0;
        this.remoteCount = 0;
        Integer n2 = new Integer(0);
        this.data = new String(JBButil.create_a_string_with_original(26, 50, 10.0f, n2, s));
        this.company = company;
        this.id = n;
        this.warehouseId = s;
        int n3 = this.company.getMaxDistrictsPerWarehouse();
        this.district_text = new String[n3];
        for (int i = 0; i < n3; ++i) {
            this.district_text[i] = new String(JBButil.create_random_a_string(25, 25, this.warehouseId));
        }
    }

    public synchronized int getQuantity() {
        int n = this.quantity;
        return n;
    }

    public synchronized void changeQuantity(int n) {
        this.quantity += n;
    }

    public synchronized void incrementOrderCount() {
        this.orderCount = (short)(this.orderCount + 1);
    }

    public synchronized void incrementRemoteCount() {
        this.remoteCount = (short)(this.remoteCount + 1);
    }

    public synchronized int getId() {
        int n = this.id;
        return n;
    }

    public synchronized String getDistrictInfo(byte by) {
        return this.district_text[by - 1];
    }

    public synchronized String getData() {
        String string = new String(this.data);
        return string;
    }

    public synchronized void incrementYTD(short s) {
        this.ytd.add(BigInteger.valueOf(s));
    }
}

