/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.extract.prefs.ExtractOptionsPanelController;
import tr.extract.prefs.ExtractPrefs;

final class ExtractPanel
extends JPanel {
    private final ExtractOptionsPanelController controller;
    private JComboBox encodingCombo;
    private JLabel encodingLabel;
    private JButton browseButton;
    private JLabel folderLabel;
    private JTextField folderField;

    ExtractPanel(ExtractOptionsPanelController controller) {
        this.controller = controller;
        this.initForm();
    }

    private void initForm() {
        this.initComponents();
        this.initFields();
        this.add((Component)this.getView(), "Center");
    }

    private JComponent getView() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "0[]2[grow]2[]0", "0[]2[]0"));
        panel.add((Component)this.folderLabel, "align right");
        panel.add((Component)this.folderField, "align left, growx 100");
        panel.add((Component)this.browseButton, "align left, wrap");
        panel.add((Component)this.encodingLabel, "align right");
        panel.add((Component)this.encodingCombo, "align left, wrap");
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        return scrollPane;
    }

    private void initFields() {
        this.folderLabel = new JLabel(this.getMsg("Output"));
        this.folderField = new JTextField();
        this.folderField.getDocument().addDocumentListener(new FolderDocumentListener());
        this.browseButton = new JButton(this.getMsg("Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExtractPanel.this.browse(evt);
            }
        });
        this.encodingLabel = new JLabel(this.getMsg("Encoding"));
        this.encodingCombo = new JComboBox();
        this.encodingCombo.setEditable(true);
        this.encodingCombo.setModel(this.getEncodingModel());
    }

    private ComboBoxModel getEncodingModel() {
        Vector<String> encodings = new Vector<String>();
        encodings.add("");
        encodings.addAll(Charset.availableCharsets().keySet());
        return new DefaultComboBoxModel(encodings);
    }

    void load() {
        this.folderField.setText(ExtractPrefs.getPath());
        this.encodingCombo.setSelectedItem(ExtractPrefs.getEncoding());
    }

    void store() {
        if (this.isValidPath()) {
            ExtractPrefs.setPath(this.getPath());
        }
        if (this.isValidEncoding()) {
            ExtractPrefs.setEncoding(this.getEncoding());
        }
    }

    boolean valid() {
        return this.isValidPath() && this.isValidEncoding();
    }

    private boolean isValidEncoding() {
        String encoding = this.getEncoding();
        if (encoding.length() == 0) {
            return true;
        }
        try {
            return Charset.isSupported(encoding);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String getEncoding() {
        String encoding = (String)this.encodingCombo.getSelectedItem();
        return encoding == null ? "" : encoding.trim();
    }

    private boolean isValidPath() {
        String path = this.getPath();
        return path.length() == 0 || new File(path).isDirectory();
    }

    private String getPath() {
        String path = this.folderField.getText().trim();
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1).trim();
        }
        return path;
    }

    private void browse(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.folderField.getText()));
        Frame p = WindowManager.getDefault().getMainWindow();
        int returnVal = fc.showOpenDialog(p);
        if (returnVal == 0) {
            try {
                this.folderField.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.folderField.setText("");
            }
        }
    }

    private String getMsg(String key) {
        return NbBundle.getMessage(ExtractPanel.class, (String)key);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class FolderDocumentListener
    implements DocumentListener {
        private FolderDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }

        public void removeUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }

        public void changedUpdate(DocumentEvent e) {
            ExtractPanel.this.controller.changed();
        }
    }
}

