/**
 * @file ada.h
 * @brief Includes all definitions for Ada.
 */
#ifndef ADA_H
#define ADA_H

#include "ada/ada_idna.h"
#include "ada/character_sets.h"
#include "ada/character_sets-inl.h"
#include "ada/checkers-inl.h"
#include "ada/common_defs.h"
#include "ada/log.h"
#include "ada/encoding_type.h"
#include "ada/helpers.h"
#include "ada/parser.h"
#include "ada/parser-inl.h"
#include "ada/scheme.h"
#include "ada/scheme-inl.h"
#include "ada/serializers.h"
#include "ada/state.h"
#include "ada/unicode.h"
#include "ada/url_base.h"
#include "ada/url_base-inl.h"
#include "ada/url-inl.h"
#include "ada/url_components.h"
#include "ada/url_components-inl.h"
#include "ada/url_aggregator.h"
#include "ada/url_aggregator-inl.h"
#include "ada/url_search_params.h"
#include "ada/url_search_params-inl.h"

#if ADA_INCLUDE_URL_PATTERN
#include "ada/url_pattern.h"
#include "ada/url_pattern-inl.h"
#include "ada/url_pattern_helpers.h"
#include "ada/url_pattern_helpers-inl.h"
#include "ada/url_pattern_regex.h"
#endif  // ADA_INCLUDE_URL_PATTERN

// Public API
#include "ada/ada_version.h"
#include "ada/implementation.h"
#include "ada/implementation-inl.h"

#endif  // ADA_H
