/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceAttributes;

public class LinkFormat {
    public static final String RESOURCE_TYPE = "rt";
    public static final String INTERFACE_DESCRIPTION = "if";
    public static final String CONTENT_TYPE = "ct";
    public static final String MAX_SIZE_ESTIMATE = "sz";
    public static final String TITLE = "title";
    public static final String OBSERVABLE = "obs";
    public static final String LINK = "href";
    public static final String LIFE_TIME = "lt";
    public static final String SECTOR = "d";
    public static final String CONTEXT = "anchor";
    public static final String BASE = "base";
    public static final String RELATION = "rel";
    public static final String END_POINT = "ep";
    public static final String END_POINT_TYPE = "et";
    public static final String COUNT = "count";
    public static final String PAGE = "page";
    public static final Pattern DELIMITER = Pattern.compile("\\s*,+\\s*");
    public static final Pattern SEPARATOR = Pattern.compile("\\s*;+\\s*");
    public static final Pattern WORD = Pattern.compile("\\w+");
    public static final Pattern QUOTED_STRING = Pattern.compile("\\G\".*?\"");
    public static final Pattern CARDINAL = Pattern.compile("\\G\\d+");

    public static String serializeTree(Resource resource) {
        StringBuilder buffer = new StringBuilder();
        List<String> noQueries = Collections.emptyList();
        for (Resource child : resource.getChildren()) {
            LinkFormat.serializeTree(child, noQueries, buffer);
        }
        if (buffer.length() > 1) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    public static void serializeTree(Resource resource, List<String> queries, StringBuilder buffer) {
        if (resource.isVisible() && LinkFormat.matches(resource, queries)) {
            buffer.append((CharSequence)LinkFormat.serializeResource(resource));
        }
        ArrayList<Resource> childs = new ArrayList<Resource>(resource.getChildren());
        Collections.sort(childs, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Resource child : childs) {
            LinkFormat.serializeTree(child, queries, buffer);
        }
    }

    public static StringBuilder serializeResource(Resource resource) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<").append(resource.getPath()).append(resource.getName()).append(">").append((CharSequence)LinkFormat.serializeAttributes(resource.getAttributes())).append(",");
        return buffer;
    }

    public static StringBuilder serializeAttributes(ResourceAttributes attributes) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> attributesList = new ArrayList<String>(attributes.getAttributeKeySet());
        Collections.sort(attributesList);
        for (String attr : attributesList) {
            List<String> values = attributes.getAttributeValues(attr);
            if (values == null) continue;
            buffer.append(";");
            buffer.append((CharSequence)LinkFormat.serializeAttribute(attr, new LinkedList<String>(values)));
        }
        return buffer;
    }

    public static StringBuilder serializeAttribute(String key, List<String> values) {
        String delimiter = "=";
        StringBuilder linkFormat = new StringBuilder();
        boolean quotes = false;
        linkFormat.append(key);
        if (values == null) {
            throw new RuntimeException("Values null");
        }
        if (values.isEmpty() || values.get(0).equals("")) {
            return linkFormat;
        }
        linkFormat.append(delimiter);
        if (values.size() > 1 || !values.get(0).matches("^[0-9]+$")) {
            linkFormat.append('\"');
            quotes = true;
        }
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            linkFormat.append(it.next());
            if (!it.hasNext()) continue;
            linkFormat.append(' ');
        }
        if (quotes) {
            linkFormat.append('\"');
        }
        return linkFormat;
    }

    public static boolean matches(Resource resource, List<String> queries) {
        if (resource == null) {
            return false;
        }
        if (queries == null || queries.size() == 0) {
            return true;
        }
        ResourceAttributes attributes = resource.getAttributes();
        String path = resource.getPath() + resource.getName();
        for (String s : queries) {
            int delim = s.indexOf("=");
            if (delim != -1) {
                String attrName = s.substring(0, delim);
                String expected = s.substring(delim + 1);
                if (attrName.equals(LINK)) {
                    if (!(expected.endsWith("*") ? !path.startsWith(expected.substring(0, expected.length() - 1)) : !path.equals(expected))) continue;
                    return false;
                }
                if (attributes.containsAttribute(attrName)) {
                    boolean matched = false;
                    for (String actual : attributes.getAttributeValues(attrName)) {
                        int prefixLength = expected.indexOf(42);
                        if (prefixLength >= 0 && prefixLength < actual.length()) {
                            String shortened = expected.substring(0, prefixLength);
                            if (!(actual = actual.substring(0, prefixLength)).equals(shortened)) continue;
                            matched = true;
                            break;
                        }
                        if (!actual.equals(expected)) continue;
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    return false;
                }
                if (attributes.containsAttribute(attrName)) continue;
                return false;
            }
            if (attributes.getAttributeValues(s).size() != 0) continue;
            return false;
        }
        return true;
    }

    public static Set<WebLink> parse(String linkFormat) {
        Pattern DELIMITER = Pattern.compile("\\s*,+\\s*");
        ConcurrentSkipListSet<WebLink> links = new ConcurrentSkipListSet<WebLink>();
        if (linkFormat != null) {
            Scanner scanner = new Scanner(linkFormat);
            String path = null;
            while ((path = scanner.findInLine("<[^>]*>")) != null) {
                path = path.substring(1, path.length() - 1);
                WebLink link = new WebLink(path);
                String attr = null;
                while (scanner.findWithinHorizon(DELIMITER, 1) == null && (attr = scanner.findInLine(WORD)) != null) {
                    if (scanner.findWithinHorizon("=", 1) != null) {
                        String value = null;
                        value = scanner.findInLine(QUOTED_STRING);
                        if (value != null) {
                            value = value.substring(1, value.length() - 1);
                            if (attr.equals(TITLE)) {
                                link.getAttributes().addAttribute(attr, value);
                                continue;
                            }
                            for (String part : value.split("\\s", 0)) {
                                link.getAttributes().addAttribute(attr, part);
                            }
                            continue;
                        }
                        value = scanner.findInLine(WORD);
                        if (value != null) {
                            link.getAttributes().setAttribute(attr, value);
                            continue;
                        }
                        value = scanner.findInLine(CARDINAL);
                        if (value != null) {
                            link.getAttributes().setAttribute(attr, value);
                            continue;
                        }
                        if (!scanner.hasNext()) continue;
                        value = scanner.next();
                        continue;
                    }
                    link.getAttributes().addAttribute(attr);
                }
                links.add(link);
            }
            scanner.close();
        }
        return links;
    }
}

