/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.network.config.NetworkConfig;

public class ReliabilityLayerParameters {
    private final int ackTimeout;
    private final float ackRandomFactor;
    private final float ackTimeoutScale;
    private final int maxRetransmit;
    private final int nstart;

    ReliabilityLayerParameters(int ackTimeout, float ackRandomFactor, float ackTimeoutScale, int maxRetransmit, int nstart) {
        this.ackTimeout = ackTimeout;
        this.ackRandomFactor = ackRandomFactor;
        this.ackTimeoutScale = ackTimeoutScale;
        this.maxRetransmit = maxRetransmit;
        this.nstart = nstart;
    }

    public int getAckTimeout() {
        return this.ackTimeout;
    }

    public float getAckRandomFactor() {
        return this.ackRandomFactor;
    }

    public float getAckTimeoutScale() {
        return this.ackTimeoutScale;
    }

    public int getMaxRetransmit() {
        return this.maxRetransmit;
    }

    public int getNstart() {
        return this.nstart;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int ackTimeout;
        private float ackRandomFactor;
        private float ackTimeoutScale;
        private int maxRetransmit;
        private int nstart;

        private Builder() {
        }

        public Builder applyConfig(NetworkConfig config) {
            this.ackTimeout = config.getInt("ACK_TIMEOUT");
            this.ackRandomFactor = config.getFloat("ACK_RANDOM_FACTOR");
            this.ackTimeoutScale = config.getFloat("ACK_TIMEOUT_SCALE");
            this.maxRetransmit = config.getInt("MAX_RETRANSMIT");
            this.nstart = config.getInt("NSTART");
            return this;
        }

        public Builder ackTimeout(int ackTimeout) {
            this.ackTimeout = ackTimeout;
            return this;
        }

        public Builder ackRandomFactor(float ackRandomFactor) {
            this.ackRandomFactor = ackRandomFactor;
            return this;
        }

        public Builder ackTimeoutScale(float ackTimeoutScale) {
            this.ackTimeoutScale = ackTimeoutScale;
            return this;
        }

        public Builder maxRetransmit(int maxRetransmit) {
            this.maxRetransmit = maxRetransmit;
            return this;
        }

        public Builder nstart(int nstart) {
            this.nstart = nstart;
            return this;
        }

        public ReliabilityLayerParameters build() {
            return new ReliabilityLayerParameters(this.ackTimeout, this.ackRandomFactor, this.ackTimeoutScale, this.maxRetransmit, this.nstart);
        }
    }
}

