/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.chart;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.ui.chart.ChartProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ChartServlet.class, Servlet.class}, configurationPid={"org.openhab.chart"}, property={"service.pid=org.openhab.chart"})
@ConfigurableService(category="system", label="Charts", description_uri="system:chart")
@HttpWhiteboardServletName(value="/chart")
@HttpWhiteboardServletPattern(value={"/chart/*"})
@NonNullByDefault
public class ChartServlet
extends HttpServlet {
    private static final long serialVersionUID = 7700873790924746422L;
    protected static final String CONFIG_URI = "system:chart";
    private static final int CHART_HEIGHT = 240;
    private static final int CHART_WIDTH = 480;
    private static final String DATE_FORMAT = "yyyyMMddHHmm";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    private final Logger logger = LoggerFactory.getLogger(ChartServlet.class);
    private final TimeZoneProvider timeZoneProvider;
    private String providerName = "default";
    private int defaultHeight = 240;
    private int defaultWidth = 480;
    private double scale = 1.0;
    private int maxWidth = -1;
    public static final String SERVLET_PATH = "/chart";
    protected static final Duration DEFAULT_PERIOD = Duration.ofDays(1L);
    protected static final Map<String, ChartProvider> CHART_PROVIDERS = new ConcurrentHashMap<String, ChartProvider>();

    @Activate
    public ChartServlet(@Reference TimeZoneProvider timeZoneProvider) {
        this.timeZoneProvider = timeZoneProvider;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addChartProvider(ChartProvider provider) {
        CHART_PROVIDERS.put(provider.getName(), provider);
    }

    public void removeChartProvider(ChartProvider provider) {
        CHART_PROVIDERS.remove(provider.getName());
    }

    public static Map<String, ChartProvider> getChartProviders() {
        return CHART_PROVIDERS;
    }

    @Activate
    protected void activate(Map<String, Object> config) {
        this.applyConfig(config);
    }

    @Modified
    protected void modified(@Nullable Map<String, Object> config) {
        this.applyConfig(config);
    }

    private void applyConfig(@Nullable Map<String, Object> config) {
        String maxWidthString;
        String scaleString;
        String defaultWidthString;
        String defaultHeightString;
        if (config == null) {
            return;
        }
        String providerNameString = Objects.toString(config.get("provider"), null);
        if (providerNameString != null) {
            this.providerName = providerNameString;
        }
        if ((defaultHeightString = Objects.toString(config.get("defaultHeight"), null)) != null) {
            try {
                this.defaultHeight = Integer.parseInt(defaultHeightString);
            }
            catch (NumberFormatException e) {
                this.logger.warn("'{}' is not a valid integer value for the defaultHeight parameter.", (Object)defaultHeightString);
            }
        }
        if ((defaultWidthString = Objects.toString(config.get("defaultWidth"), null)) != null) {
            try {
                this.defaultWidth = Integer.parseInt(defaultWidthString);
            }
            catch (NumberFormatException e) {
                this.logger.warn("'{}' is not a valid integer value for the defaultWidth parameter.", (Object)defaultWidthString);
            }
        }
        if ((scaleString = Objects.toString(config.get("scale"), null)) != null) {
            try {
                this.scale = Double.parseDouble(scaleString);
                if (this.scale < 0.1) {
                    this.scale = 1.0;
                }
            }
            catch (NumberFormatException e) {
                this.logger.warn("'{}' is not a valid number value for the scale parameter.", (Object)scaleString);
            }
        }
        if ((maxWidthString = Objects.toString(config.get("maxWidth"), null)) != null) {
            try {
                this.maxWidth = Integer.parseInt(maxWidthString);
            }
            catch (NumberFormatException e) {
                this.logger.warn("'{}' is not a valid integer value for the maxWidth parameter.", (Object)maxWidthString);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PeriodPastFuture period;
        PeriodBeginEnd beginEnd;
        this.logger.debug("Received incoming chart request: {}", (Object)req);
        int width = this.defaultWidth;
        String w = req.getParameter("w");
        if (w != null) {
            try {
                width = Integer.parseInt(w);
            }
            catch (NumberFormatException e) {
                this.logger.debug("Ignoring invalid value '{}' for HTTP request parameter 'w'", (Object)w);
            }
        }
        int height = this.defaultHeight;
        String h = req.getParameter("h");
        if (h != null) {
            try {
                Double d = Double.parseDouble(h) * this.scale;
                height = d.intValue();
            }
            catch (NumberFormatException e) {
                this.logger.debug("Ignoring invalid value '{}' for HTTP request parameter 'h'", (Object)h);
            }
        }
        String periodParam = req.getParameter("period");
        String timeBeginParam = req.getParameter("begin");
        String timeEndParam = req.getParameter("end");
        if (periodParam != null && timeBeginParam != null && timeEndParam != null) {
            res.sendError(400, "Do not specify the three parameters period, begin and end at the same time.");
            return;
        }
        ZonedDateTime timeBegin = null;
        ZonedDateTime timeEnd = null;
        if (timeBeginParam != null) {
            try {
                timeBegin = LocalDateTime.parse(timeBeginParam, FORMATTER).atZone(this.timeZoneProvider.getTimeZone());
            }
            catch (DateTimeParseException e) {
                res.sendError(400, "Begin and end must have this format: yyyyMMddHHmm.");
                return;
            }
        }
        if (timeEndParam != null) {
            try {
                timeEnd = LocalDateTime.parse(timeEndParam, FORMATTER).atZone(this.timeZoneProvider.getTimeZone());
            }
            catch (DateTimeParseException e) {
                res.sendError(400, "Begin and end must have this format: yyyyMMddHHmm.");
                return;
            }
        }
        if ((beginEnd = ChartServlet.getPeriodBeginEnd(timeBegin, timeEnd, period = ChartServlet.getPeriodPastFuture(periodParam), ZonedDateTime.now(this.timeZoneProvider.getTimeZone()))).begin() != null && beginEnd.end() != null && beginEnd.end().isBefore(beginEnd.begin())) {
            res.sendError(400, "The end is before the begin.");
            return;
        }
        String serviceName = req.getParameter("service");
        ChartProvider provider = ChartServlet.getChartProviders().get(this.providerName);
        if (provider == null) {
            res.sendError(500, "Could not get chart provider.");
            return;
        }
        Integer dpi = null;
        String dpiString = req.getParameter("dpi");
        if (dpiString != null) {
            try {
                dpi = Integer.valueOf(dpiString);
            }
            catch (NumberFormatException e) {
                res.sendError(400, "dpi parameter is invalid");
                return;
            }
            if (dpi <= 0) {
                res.sendError(400, "dpi parameter is <= 0");
                return;
            }
        }
        String yAxisDecimalPattern = req.getParameter("yAxisDecimalPattern");
        String legendParam = req.getParameter("legend");
        Boolean legend = null;
        if (legendParam != null) {
            legend = Boolean.valueOf(legendParam);
        }
        if (this.maxWidth > 0 && width > this.maxWidth) {
            height = Math.round((float)height / (float)width * (float)this.maxWidth);
            if (dpi != null) {
                dpi = Math.round((float)dpi.intValue() / (float)width * (float)this.maxWidth);
            }
            width = this.maxWidth;
        }
        this.logger.debug("chart building with width {} height {} dpi {}", new Object[]{width, height, dpi});
        try {
            BufferedImage chart = provider.createChart(serviceName, req.getParameter("theme"), beginEnd.begin(), beginEnd.end(), height, width, req.getParameter("items"), req.getParameter("groups"), dpi, yAxisDecimalPattern, legend);
            res.setContentType("image/" + String.valueOf((Object)provider.getChartType()));
            Throwable throwable = null;
            Object var23_33 = null;
            try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(res.getOutputStream());){
                ImageIO.write((RenderedImage)chart, provider.getChartType().toString(), imageOutputStream);
                this.logger.debug("Chart successfully generated and written to the response.");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.debug("{}", (Object)e.getMessage());
            res.sendError(400, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Illegal argument in chart: {}", (Object)e.getMessage());
            res.sendError(400, "Illegal argument in chart: " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.debug("Failed writing image to response stream", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.warn("Chart generation failed: {}", (Object)e.getMessage(), (Object)(this.logger.isDebugEnabled() ? e : null));
            res.sendError(500, e.getMessage());
        }
    }

    public void init(@Nullable ServletConfig config) throws ServletException {
    }

    public @Nullable ServletConfig getServletConfig() {
        return null;
    }

    public @Nullable String getServletInfo() {
        return null;
    }

    public void destroy() {
    }

    protected static @Nullable TemporalAmount convertToTemporalAmount(@Nullable String periodParam, @Nullable TemporalAmount defaultPeriod) {
        TemporalAmount period = defaultPeriod;
        String convertedPeriod = ChartServlet.convertPeriodToISO8601(periodParam);
        if (convertedPeriod != null) {
            boolean failed = false;
            try {
                period = Period.parse(convertedPeriod);
            }
            catch (DateTimeParseException e) {
                failed = true;
            }
            if (failed) {
                try {
                    period = Duration.parse(convertedPeriod);
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            }
        }
        return period;
    }

    private static @Nullable String convertPeriodToISO8601(@Nullable String period) {
        Object newPeriod;
        if (period == null || period.startsWith("P") || !period.endsWith("h") && !period.endsWith("D") && !period.endsWith("W") && !period.endsWith("M") && !period.endsWith("Y")) {
            return period;
        }
        Object object = newPeriod = period.length() == 1 ? "1" + period : period;
        if (((String)newPeriod).endsWith("h")) {
            newPeriod = "T" + ((String)newPeriod).replace("h", "H");
        }
        return "P" + (String)newPeriod;
    }

    protected static PeriodPastFuture getPeriodPastFuture(@Nullable String periodParam) {
        String periodParamPast = null;
        String periodParamFuture = null;
        Duration defaultPeriodPast = DEFAULT_PERIOD;
        Duration defaultPeriodFuture = null;
        if (periodParam != null) {
            int idx = periodParam.indexOf("-");
            if (idx < 0) {
                periodParamPast = periodParam;
            } else {
                if (idx > 0) {
                    periodParamPast = periodParam.substring(0, idx);
                } else {
                    defaultPeriodPast = null;
                    defaultPeriodFuture = DEFAULT_PERIOD;
                }
                periodParamFuture = periodParam.substring(idx + 1);
            }
        }
        TemporalAmount periodPast = ChartServlet.convertToTemporalAmount(periodParamPast, defaultPeriodPast);
        TemporalAmount periodFuture = ChartServlet.convertToTemporalAmount(periodParamFuture, defaultPeriodFuture);
        return new PeriodPastFuture(periodPast, periodFuture);
    }

    protected static PeriodBeginEnd getPeriodBeginEnd(@Nullable ZonedDateTime begin, @Nullable ZonedDateTime end, PeriodPastFuture period, ZonedDateTime now) {
        ZonedDateTime timeBegin = begin;
        ZonedDateTime timeEnd = end;
        TemporalAmount periodPast = period.past();
        TemporalAmount periodFuture = period.future();
        if (timeBegin == null && timeEnd == null) {
            timeBegin = timeEnd = now;
            if (periodPast != null) {
                timeBegin = timeBegin.minus(periodPast);
            }
            if (periodFuture != null) {
                timeEnd = timeEnd.plus(periodFuture);
            }
        } else if (timeBegin != null && timeEnd == null) {
            timeEnd = timeBegin;
            if (periodPast != null) {
                timeEnd = timeEnd.plus(periodPast);
            }
            if (periodFuture != null) {
                timeEnd = timeEnd.plus(periodFuture);
            }
        } else if (timeBegin == null && timeEnd != null) {
            timeBegin = timeEnd;
            if (periodFuture != null) {
                timeBegin = timeBegin.minus(periodFuture);
            }
            if (periodPast != null) {
                timeBegin = timeBegin.minus(periodPast);
            }
        }
        return new PeriodBeginEnd(Objects.requireNonNull(timeBegin), Objects.requireNonNull(timeEnd));
    }

    record PeriodBeginEnd(ZonedDateTime begin, ZonedDateTime end) {
    }

    record PeriodPastFuture(@Nullable TemporalAmount past, @Nullable TemporalAmount future) {
    }
}

