/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util.property;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Properties;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerableProperties;

public abstract class Property {
    protected final Properties properties;
    private final String path;
    private final String defaultValue;
    private final TriggerList triggerList = new TriggerList(null);

    protected Property(Properties properties, String string, String string2) {
        this.properties = properties;
        this.path = string;
        this.defaultValue = string2;
        if (properties instanceof TriggerableProperties) {
            ((TriggerableProperties)properties).register(this);
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected String getInternal(String string, boolean bl) {
        String string2 = this.properties.getProperty(this.path, string);
        if (string2 != null) {
            return string2;
        }
        if (string == null && (string2 = this.getDefaultValue()) != null) {
            return string2;
        }
        if (bl) {
            throw new RuntimeException("Property " + this.path + " must be set");
        }
        return string2;
    }

    public synchronized void addTrigger(Trigger trigger) {
        this.triggerList.add(trigger);
    }

    public synchronized void removeTrigger(Trigger trigger) {
        this.triggerList.remove(trigger);
    }

    public void onChange(String string, String string2) {
        if (TriggerableProperties.equals(string, string2)) {
            return;
        }
        this.triggerList.execute(this, string2);
    }

    public String setString(String string) {
        return (String)this.properties.setProperty(this.path, string);
    }

    public boolean isSet() {
        return this.properties.get(this.path) != null;
    }

    public String getString() {
        return this.properties.getProperty(this.path, this.defaultValue);
    }

    public boolean booleanValue() {
        String string = this.getInternal(null, false);
        if (string == null) {
            return false;
        }
        return Property.toBoolean(string);
    }

    public static boolean toBoolean(String string) {
        String string2 = string.toLowerCase().trim();
        return string2.equals("1") || string2.equals("true") || string2.equals("yes");
    }

    public String stringValue() {
        return this.getInternal(null, false);
    }

    static class 1 {
    }

    private static class TriggerList
    extends ArrayList {
        private TriggerList() {
        }

        void add(Trigger trigger) {
            Object object = trigger.isPersistent() ? trigger : new WeakReference<Trigger>(trigger);
            ListIterator<Object> listIterator = this.listIterator();
            while (listIterator.hasNext()) {
                Trigger trigger2 = this.convert(listIterator.next());
                if (trigger2 == null) {
                    listIterator.remove();
                    continue;
                }
                if (trigger.phase() < trigger2.phase()) {
                    listIterator.hasPrevious();
                    listIterator.add(object);
                    return;
                }
                if (trigger.phase() != trigger2.phase()) continue;
                listIterator.add(object);
                return;
            }
            super.add(object);
        }

        void remove(Trigger trigger) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Trigger trigger2 = this.convert(iterator.next());
                if (trigger2 == null) {
                    iterator.remove();
                    continue;
                }
                if (!trigger2.equals(trigger)) continue;
                iterator.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute(Property property, String string) throws Trigger.VetoRT {
            Object object;
            ArrayList<Trigger> arrayList = new ArrayList<Trigger>();
            Object object2 = property;
            synchronized (object2) {
                object = this.iterator();
                while (object.hasNext()) {
                    Trigger trigger = this.convert(object.next());
                    if (trigger == null) {
                        object.remove();
                        continue;
                    }
                    arrayList.add(trigger);
                }
            }
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (Trigger)object2.next();
                object.execute(property, string);
            }
        }

        private Trigger convert(Object object) {
            if (object instanceof WeakReference) {
                object = ((WeakReference)object).get();
            }
            return (Trigger)object;
        }

        TriggerList(1 var1_1) {
            this();
        }
    }
}

