/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.concurrency.Propagation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J%\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J'\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u0018\u001a\u00020\u00062\n\u0010\u001b\u001a\u00060\u001ej\u0002`\u001fJ\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/com/intellij/util/concurrency/ChildContext;", "", "context", "Lkotlin/coroutines/CoroutineContext;", "continuation", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;)V", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "getContinuation", "()Lkotlin/coroutines/Continuation;", "job", "Lkotlinx/coroutines/Job;", "getJob", "()Lkotlinx/coroutines/Job;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "runAsCoroutine", "T", "completeOnFinish", "action", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "toString", "", "intellij.platform.util"})
@ApiStatus.Internal
public final class ChildContext {
    @NotNull
    private final CoroutineContext context;
    @Nullable
    private final Continuation<Unit> continuation;

    public ChildContext(@NotNull CoroutineContext context, @Nullable Continuation<? super Unit> continuation2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.continuation = continuation2;
    }

    @NotNull
    public final CoroutineContext getContext() {
        return this.context;
    }

    @Nullable
    public final Job getJob() {
        CoroutineContext coroutineContext = this.continuation;
        return coroutineContext != null && (coroutineContext = coroutineContext.getContext()) != null ? JobKt.getJob((CoroutineContext)coroutineContext) : null;
    }

    public final void runAsCoroutine(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.runAsCoroutine(true, (Function0)new Function0<Unit>((Object)action){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        });
    }

    public final <T> T runAsCoroutine(boolean completeOnFinish, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (T)(this.continuation == null ? action.invoke() : Propagation.runAsCoroutine(this.continuation, completeOnFinish, action));
    }

    @NotNull
    public final CoroutineContext component1() {
        return this.context;
    }

    @Nullable
    public final Continuation<Unit> component2() {
        return this.continuation;
    }

    @NotNull
    public String toString() {
        return "ChildContext(context=" + this.context + ", continuation=" + this.continuation + ')';
    }

    public int hashCode() {
        int result2 = this.context.hashCode();
        result2 = result2 * 31 + (this.continuation == null ? 0 : this.continuation.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChildContext)) {
            return false;
        }
        ChildContext childContext = (ChildContext)other;
        if (!Intrinsics.areEqual((Object)this.context, (Object)childContext.context)) {
            return false;
        }
        return Intrinsics.areEqual(this.continuation, childContext.continuation);
    }
}

