/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrGraphicsRequirementsVulkanKHR;
import org.lwjgl.openxr.XrInstance;
import org.lwjgl.openxr.XrVulkanDeviceCreateInfoKHR;
import org.lwjgl.openxr.XrVulkanGraphicsDeviceGetInfoKHR;
import org.lwjgl.openxr.XrVulkanInstanceCreateInfoKHR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class KHRVulkanEnable2 {
    public static final int XR_KHR_vulkan_enable2_SPEC_VERSION = 2;
    public static final String XR_KHR_VULKAN_ENABLE2_EXTENSION_NAME = "XR_KHR_vulkan_enable2";
    public static final int XR_TYPE_VULKAN_INSTANCE_CREATE_INFO_KHR = 1000090000;
    public static final int XR_TYPE_VULKAN_DEVICE_CREATE_INFO_KHR = 1000090001;
    public static final int XR_TYPE_VULKAN_GRAPHICS_DEVICE_GET_INFO_KHR = 1000090003;
    public static final int XR_TYPE_GRAPHICS_BINDING_VULKAN2_KHR = 1000090000;
    public static final int XR_TYPE_SWAPCHAIN_IMAGE_VULKAN2_KHR = 1000090001;
    public static final int XR_TYPE_GRAPHICS_REQUIREMENTS_VULKAN2_KHR = 1000090002;

    protected KHRVulkanEnable2() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreateVulkanInstanceKHR(XrInstance instance, long createInfo, long vulkanInstance, long vulkanResult) {
        long __functionAddress = instance.getCapabilities().xrCreateVulkanInstanceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrVulkanInstanceCreateInfoKHR.validate(createInfo);
        }
        return JNI.callPPPPI((long)instance.address(), (long)createInfo, (long)vulkanInstance, (long)vulkanResult, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateVulkanInstanceKHR(XrInstance instance, @NativeType(value="XrVulkanInstanceCreateInfoKHR const *") XrVulkanInstanceCreateInfoKHR createInfo, @NativeType(value="VkInstance *") PointerBuffer vulkanInstance, @NativeType(value="VkResult *") IntBuffer vulkanResult) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)vulkanInstance, (int)1);
            Checks.check((Buffer)vulkanResult, (int)1);
        }
        return KHRVulkanEnable2.nxrCreateVulkanInstanceKHR(instance, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)vulkanInstance), MemoryUtil.memAddress((IntBuffer)vulkanResult));
    }

    public static int nxrCreateVulkanDeviceKHR(XrInstance instance, long createInfo, long vulkanDevice, long vulkanResult) {
        long __functionAddress = instance.getCapabilities().xrCreateVulkanDeviceKHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrVulkanDeviceCreateInfoKHR.validate(createInfo);
        }
        return JNI.callPPPPI((long)instance.address(), (long)createInfo, (long)vulkanDevice, (long)vulkanResult, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreateVulkanDeviceKHR(XrInstance instance, @NativeType(value="XrVulkanDeviceCreateInfoKHR const *") XrVulkanDeviceCreateInfoKHR createInfo, @NativeType(value="VkDevice *") PointerBuffer vulkanDevice, @NativeType(value="VkResult *") IntBuffer vulkanResult) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)vulkanDevice, (int)1);
            Checks.check((Buffer)vulkanResult, (int)1);
        }
        return KHRVulkanEnable2.nxrCreateVulkanDeviceKHR(instance, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)vulkanDevice), MemoryUtil.memAddress((IntBuffer)vulkanResult));
    }

    public static int nxrGetVulkanGraphicsDevice2KHR(XrInstance instance, long getInfo, long vulkanPhysicalDevice) {
        long __functionAddress = instance.getCapabilities().xrGetVulkanGraphicsDevice2KHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrVulkanGraphicsDeviceGetInfoKHR.validate(getInfo);
        }
        return JNI.callPPPI((long)instance.address(), (long)getInfo, (long)vulkanPhysicalDevice, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVulkanGraphicsDevice2KHR(XrInstance instance, @NativeType(value="XrVulkanGraphicsDeviceGetInfoKHR const *") XrVulkanGraphicsDeviceGetInfoKHR getInfo, @NativeType(value="VkPhysicalDevice *") PointerBuffer vulkanPhysicalDevice) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)vulkanPhysicalDevice, (int)1);
        }
        return KHRVulkanEnable2.nxrGetVulkanGraphicsDevice2KHR(instance, getInfo.address(), MemoryUtil.memAddress((CustomBuffer)vulkanPhysicalDevice));
    }

    public static int nxrGetVulkanGraphicsRequirements2KHR(XrInstance instance, long systemId, long graphicsRequirements) {
        long __functionAddress = instance.getCapabilities().xrGetVulkanGraphicsRequirements2KHR;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)instance.address(), (long)systemId, (long)graphicsRequirements, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetVulkanGraphicsRequirements2KHR(XrInstance instance, @NativeType(value="XrSystemId") long systemId, @NativeType(value="XrGraphicsRequirementsVulkanKHR *") XrGraphicsRequirementsVulkanKHR graphicsRequirements) {
        return KHRVulkanEnable2.nxrGetVulkanGraphicsRequirements2KHR(instance, systemId, graphicsRequirements.address());
    }
}

