/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaAllocateDeviceMemoryFunction;
import org.lwjgl.util.vma.VmaAllocateDeviceMemoryFunctionI;
import org.lwjgl.util.vma.VmaFreeDeviceMemoryFunction;
import org.lwjgl.util.vma.VmaFreeDeviceMemoryFunctionI;

public class VmaDeviceMemoryCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PFNALLOCATE;
    public static final int PFNFREE;
    public static final int PUSERDATA;

    public VmaDeviceMemoryCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaDeviceMemoryCallbacks.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction")
    public VmaAllocateDeviceMemoryFunction pfnAllocate() {
        return VmaDeviceMemoryCallbacks.npfnAllocate(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vmaFreeDeviceMemoryFunction")
    public VmaFreeDeviceMemoryFunction pfnFree() {
        return VmaDeviceMemoryCallbacks.npfnFree(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaDeviceMemoryCallbacks.npUserData(this.address());
    }

    public VmaDeviceMemoryCallbacks pfnAllocate(@Nullable @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction") VmaAllocateDeviceMemoryFunctionI value) {
        VmaDeviceMemoryCallbacks.npfnAllocate(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks pfnFree(@Nullable @NativeType(value="PFN_vmaFreeDeviceMemoryFunction") VmaFreeDeviceMemoryFunctionI value) {
        VmaDeviceMemoryCallbacks.npfnFree(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks pUserData(@NativeType(value="void *") long value) {
        VmaDeviceMemoryCallbacks.npUserData(this.address(), value);
        return this;
    }

    public VmaDeviceMemoryCallbacks set(VmaAllocateDeviceMemoryFunctionI pfnAllocate, VmaFreeDeviceMemoryFunctionI pfnFree, long pUserData) {
        this.pfnAllocate(pfnAllocate);
        this.pfnFree(pfnFree);
        this.pUserData(pUserData);
        return this;
    }

    public VmaDeviceMemoryCallbacks set(VmaDeviceMemoryCallbacks src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VmaDeviceMemoryCallbacks malloc() {
        return (VmaDeviceMemoryCallbacks)VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks calloc() {
        return (VmaDeviceMemoryCallbacks)VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaDeviceMemoryCallbacks)VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaDeviceMemoryCallbacks create(long address) {
        return (VmaDeviceMemoryCallbacks)VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, (long)address);
    }

    @Nullable
    public static VmaDeviceMemoryCallbacks createSafe(long address) {
        return address == 0L ? null : (VmaDeviceMemoryCallbacks)VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaDeviceMemoryCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaDeviceMemoryCallbacks.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaDeviceMemoryCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDeviceMemoryCallbacks.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaDeviceMemoryCallbacks.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaDeviceMemoryCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaDeviceMemoryCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks mallocStack() {
        return VmaDeviceMemoryCallbacks.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks callocStack() {
        return VmaDeviceMemoryCallbacks.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks mallocStack(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.malloc(stack);
    }

    @Deprecated
    public static VmaDeviceMemoryCallbacks callocStack(MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDeviceMemoryCallbacks.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDeviceMemoryCallbacks.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDeviceMemoryCallbacks.calloc(capacity, stack);
    }

    public static VmaDeviceMemoryCallbacks malloc(MemoryStack stack) {
        return (VmaDeviceMemoryCallbacks)VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDeviceMemoryCallbacks calloc(MemoryStack stack) {
        return (VmaDeviceMemoryCallbacks)VmaDeviceMemoryCallbacks.wrap(VmaDeviceMemoryCallbacks.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaDeviceMemoryCallbacks.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaDeviceMemoryCallbacks.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    @Nullable
    public static VmaAllocateDeviceMemoryFunction npfnAllocate(long struct) {
        return VmaAllocateDeviceMemoryFunction.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PFNALLOCATE)));
    }

    @Nullable
    public static VmaFreeDeviceMemoryFunction npfnFree(long struct) {
        return VmaFreeDeviceMemoryFunction.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PFNFREE)));
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PUSERDATA));
    }

    public static void npfnAllocate(long struct, @Nullable VmaAllocateDeviceMemoryFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNALLOCATE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npfnFree(long struct, @Nullable VmaFreeDeviceMemoryFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNFREE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PUSERDATA), (long)value);
    }

    static {
        Struct.Layout layout = VmaDeviceMemoryCallbacks.__struct((Struct.Member[])new Struct.Member[]{VmaDeviceMemoryCallbacks.__member((int)POINTER_SIZE), VmaDeviceMemoryCallbacks.__member((int)POINTER_SIZE), VmaDeviceMemoryCallbacks.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PFNALLOCATE = layout.offsetof(0);
        PFNFREE = layout.offsetof(1);
        PUSERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VmaDeviceMemoryCallbacks, Buffer>
    implements NativeResource {
        private static final VmaDeviceMemoryCallbacks ELEMENT_FACTORY = VmaDeviceMemoryCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaDeviceMemoryCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Nullable
        @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction")
        public VmaAllocateDeviceMemoryFunction pfnAllocate() {
            return VmaDeviceMemoryCallbacks.npfnAllocate(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vmaFreeDeviceMemoryFunction")
        public VmaFreeDeviceMemoryFunction pfnFree() {
            return VmaDeviceMemoryCallbacks.npfnFree(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaDeviceMemoryCallbacks.npUserData(this.address());
        }

        public Buffer pfnAllocate(@Nullable @NativeType(value="PFN_vmaAllocateDeviceMemoryFunction") VmaAllocateDeviceMemoryFunctionI value) {
            VmaDeviceMemoryCallbacks.npfnAllocate(this.address(), value);
            return this;
        }

        public Buffer pfnFree(@Nullable @NativeType(value="PFN_vmaFreeDeviceMemoryFunction") VmaFreeDeviceMemoryFunctionI value) {
            VmaDeviceMemoryCallbacks.npfnFree(this.address(), value);
            return this;
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VmaDeviceMemoryCallbacks.npUserData(this.address(), value);
            return this;
        }
    }
}

