/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiAABB")
public class AIAABB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MMIN;
    public static final int MMAX;

    public AIAABB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIAABB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mMin() {
        return AIAABB.nmMin(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mMax() {
        return AIAABB.nmMax(this.address());
    }

    public AIAABB mMin(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AIAABB.nmMin(this.address(), value);
        return this;
    }

    public AIAABB mMin(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mMin());
        return this;
    }

    public AIAABB mMax(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AIAABB.nmMax(this.address(), value);
        return this;
    }

    public AIAABB mMax(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mMax());
        return this;
    }

    public AIAABB set(AIVector3D mMin, AIVector3D mMax) {
        this.mMin(mMin);
        this.mMax(mMax);
        return this;
    }

    public AIAABB set(AIAABB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIAABB malloc() {
        return (AIAABB)AIAABB.wrap(AIAABB.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIAABB calloc() {
        return (AIAABB)AIAABB.wrap(AIAABB.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIAABB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIAABB)AIAABB.wrap(AIAABB.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIAABB create(long address) {
        return (AIAABB)AIAABB.wrap(AIAABB.class, (long)address);
    }

    @Nullable
    public static AIAABB createSafe(long address) {
        return address == 0L ? null : (AIAABB)AIAABB.wrap(AIAABB.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIAABB.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIAABB.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIAABB.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIAABB.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIAABB.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIAABB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIAABB.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static AIAABB mallocStack() {
        return AIAABB.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAABB callocStack() {
        return AIAABB.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAABB mallocStack(MemoryStack stack) {
        return AIAABB.malloc(stack);
    }

    @Deprecated
    public static AIAABB callocStack(MemoryStack stack) {
        return AIAABB.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIAABB.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIAABB.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIAABB.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIAABB.calloc(capacity, stack);
    }

    public static AIAABB malloc(MemoryStack stack) {
        return (AIAABB)AIAABB.wrap(AIAABB.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIAABB calloc(MemoryStack stack) {
        return (AIAABB)AIAABB.wrap(AIAABB.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)AIAABB.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)AIAABB.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static AIVector3D nmMin(long struct) {
        return AIVector3D.create(struct + (long)MMIN);
    }

    public static AIVector3D nmMax(long struct) {
        return AIVector3D.create(struct + (long)MMAX);
    }

    public static void nmMin(long struct, AIVector3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MMIN), (long)AIVector3D.SIZEOF);
    }

    public static void nmMax(long struct, AIVector3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MMAX), (long)AIVector3D.SIZEOF);
    }

    static {
        Struct.Layout layout = AIAABB.__struct((Struct.Member[])new Struct.Member[]{AIAABB.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AIAABB.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MMIN = layout.offsetof(0);
        MMAX = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIAABB, Buffer>
    implements NativeResource {
        private static final AIAABB ELEMENT_FACTORY = AIAABB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIAABB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mMin() {
            return AIAABB.nmMin(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mMax() {
            return AIAABB.nmMax(this.address());
        }

        public Buffer mMin(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AIAABB.nmMin(this.address(), value);
            return this;
        }

        public Buffer mMin(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mMin());
            return this;
        }

        public Buffer mMax(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AIAABB.nmMax(this.address(), value);
            return this;
        }

        public Buffer mMax(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mMax());
            return this;
        }
    }
}

