/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;

public class CssAppearance
extends org.w3c.css.properties.css.CssAppearance {
    public static final CssIdent auto = CssIdent.getIdent("auto");
    public static final CssIdent[] allowed_values;
    public static final CssIdent[] compat_auto;

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static boolean isCompatAuto(CssIdent ident) {
        for (CssIdent id : compat_auto) {
            if (!id.equals(ident)) continue;
            return true;
        }
        return false;
    }

    public CssAppearance() {
        this.value = initial;
    }

    public CssAppearance(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        if (check && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        if (val.getType() == 0) {
            CssIdent id = val.getIdent();
            if (CssIdent.isCssWide(id)) {
                this.value = val;
            } else {
                if (CssAppearance.getAllowedIdent(id) == null) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                this.value = val;
                if (CssAppearance.isCompatAuto(id)) {
                    ac.getFrame().addWarning("value-unofficial", val.toString(), this.getPropertyName());
                    if (val.getRawType() == 0) {
                        this.value = auto;
                    }
                }
            }
        } else {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
        expression.next();
    }

    public CssAppearance(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean isDefault() {
        return this.value == none || this.value == initial;
    }

    static {
        String[] _allowed_values = new String[]{"none", "auto", "textfield", "menulist-button"};
        String[] _compat_values = new String[]{"searchfield", "textarea", "push-button", "slider-horizontal", "checkbox", "radio", "square-button", "menulist", "listbox", "meter", "progress-bar", "button"};
        allowed_values = new CssIdent[_allowed_values.length + _compat_values.length];
        compat_auto = new CssIdent[_compat_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssAppearance.allowed_values[i++] = CssIdent.getIdent(s);
        }
        for (String s : _compat_values) {
            CssAppearance.allowed_values[i++] = CssIdent.getIdent(s);
        }
        i = 0;
        for (String s : _compat_values) {
            CssAppearance.compat_auto[i++] = CssIdent.getIdent(s);
        }
    }
}

