/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SchemaWatcher
implements SPListener {
    private static final Logger logger = Logger.getLogger(SchemaWatcher.class);
    private final Map<String, MondrianModel.Dimension> publicDimensions = new HashMap<String, MondrianModel.Dimension>();
    private final Map<CubeDimensionKey, MondrianModel.CubeDimension> cubeDimensions = new HashMap<CubeDimensionKey, MondrianModel.CubeDimension>();
    private final Map<String, MondrianModel.Cube> cubes = new HashMap<String, MondrianModel.Cube>();
    private final Map<String, MondrianModel.VirtualCube> vCubes = new HashMap<String, MondrianModel.VirtualCube>();
    private final Map<MondrianModel.Dimension, List<MondrianModel.DimensionUsage>> dimensionUsageMap = new HashMap<MondrianModel.Dimension, List<MondrianModel.DimensionUsage>>();
    private final Map<MondrianModel.Cube, List<MondrianModel.CubeUsage>> cubeUsageMap = new HashMap<MondrianModel.Cube, List<MondrianModel.CubeUsage>>();
    private final Map<MondrianModel.CubeDimension, List<MondrianModel.VirtualCubeDimension>> vCubeDimensionMap = new HashMap<MondrianModel.CubeDimension, List<MondrianModel.VirtualCubeDimension>>();

    public SchemaWatcher(MondrianModel.Schema schema) {
        this.populateNameToObjectMaps(schema);
        this.populateParentToReferencesMaps(schema);
        SQLPowerUtils.listenToHierarchy((SPObject)schema, (SPListener)this);
    }

    private void populateNameToObjectMaps(OLAPObject parent) {
        for (OLAPObject child : parent.getChildren(OLAPObject.class)) {
            if (child instanceof MondrianModel.Cube) {
                this.cubes.put(child.getName().toLowerCase(), (MondrianModel.Cube)child);
            } else if (parent instanceof MondrianModel.Cube && child instanceof MondrianModel.CubeDimension) {
                CubeDimensionKey cubeDimKey = new CubeDimensionKey(parent.getName(), child.getName());
                this.cubeDimensions.put(cubeDimKey, (MondrianModel.CubeDimension)child);
            } else if (child instanceof MondrianModel.Dimension) {
                this.publicDimensions.put(child.getName().toLowerCase(), (MondrianModel.Dimension)child);
            } else if (child instanceof MondrianModel.VirtualCube) {
                this.vCubes.put(child.getName().toLowerCase(), (MondrianModel.VirtualCube)child);
            }
            if (!child.allowsChildren()) continue;
            this.populateNameToObjectMaps(child);
        }
    }

    private void populateParentToReferencesMaps(OLAPObject parent) {
        for (OLAPObject child : parent.getChildren(OLAPObject.class)) {
            MondrianModel.VirtualCube vCube;
            if (child instanceof MondrianModel.DimensionUsage) {
                MondrianModel.DimensionUsage du = (MondrianModel.DimensionUsage)child;
                this.addToDimensionUsagesMap(du);
            } else if (child instanceof MondrianModel.VirtualCubeDimension) {
                MondrianModel.VirtualCubeDimension vcd = (MondrianModel.VirtualCubeDimension)child;
                this.addToVCubeDimensionsMap(vcd);
            } else if (child instanceof MondrianModel.VirtualCube && (vCube = (MondrianModel.VirtualCube)child).getCubeUsage() != null) {
                for (MondrianModel.CubeUsage cu : vCube.getCubeUsage().getCubeUsages()) {
                    this.addToCubeUsagesMap(cu);
                }
            }
            if (!child.allowsChildren()) continue;
            this.populateParentToReferencesMaps(child);
        }
    }

    private void addToDimensionUsagesMap(MondrianModel.DimensionUsage du) {
        MondrianModel.Dimension dim = this.publicDimensions.get(du.getSource().toLowerCase());
        if (dim == null) {
            logger.error((Object)("Can't find the Dimension that this DimensionUsage references: " + (Object)((Object)du)));
            throw new IllegalStateException("The schema structure is corrupted, invalid reference by: " + (Object)((Object)du));
        }
        List<MondrianModel.DimensionUsage> dimUsages = this.dimensionUsageMap.get((Object)dim);
        if (dimUsages == null) {
            dimUsages = new ArrayList<MondrianModel.DimensionUsage>();
            dimUsages.add(du);
            this.dimensionUsageMap.put(dim, dimUsages);
        } else {
            dimUsages.add(du);
        }
    }

    private void addToVCubeDimensionsMap(MondrianModel.VirtualCubeDimension vcd) {
        MondrianModel.CubeDimension cd;
        if (vcd.getCubeName() == null) {
            cd = this.publicDimensions.get(vcd.getName().toLowerCase());
        } else {
            CubeDimensionKey cubeDimKey = new CubeDimensionKey(vcd.getCubeName(), vcd.getName());
            cd = this.cubeDimensions.get(cubeDimKey);
        }
        if (cd == null) {
            logger.error((Object)("Can't find the CubeDimension that this VirtualCubeDimension references: " + (Object)((Object)vcd)));
            throw new IllegalStateException("The schema structure is corrupted, invalid reference by: " + (Object)((Object)vcd));
        }
        List<MondrianModel.VirtualCubeDimension> vCubeDims = this.vCubeDimensionMap.get((Object)cd);
        if (vCubeDims == null) {
            vCubeDims = new ArrayList<MondrianModel.VirtualCubeDimension>();
            vCubeDims.add(vcd);
            this.vCubeDimensionMap.put(cd, vCubeDims);
        } else {
            vCubeDims.add(vcd);
        }
    }

    private void addToCubeUsagesMap(MondrianModel.CubeUsage cu) {
        MondrianModel.Cube cube = this.cubes.get(cu.getCubeName().toLowerCase());
        if (cube == null) {
            logger.error((Object)("Can't find the Cube that this CubeUsage references: " + (Object)((Object)cu)));
            throw new IllegalStateException("The schema structure is corrupted, invalid reference by: " + (Object)((Object)cu));
        }
        List<MondrianModel.CubeUsage> cubeUsages = this.cubeUsageMap.get((Object)cube);
        if (cubeUsages != null) {
            cubeUsages.add(cu);
        } else {
            cubeUsages = new ArrayList<MondrianModel.CubeUsage>();
            cubeUsages.add(cu);
            this.cubeUsageMap.put(cube, cubeUsages);
        }
    }

    public void childAdded(SPChildEvent e) {
        if (e.getSource() instanceof MondrianModel.Cube && e.getChild() instanceof MondrianModel.CubeDimension) {
            MondrianModel.Cube c = (MondrianModel.Cube)e.getSource();
            MondrianModel.CubeDimension cd = (MondrianModel.CubeDimension)e.getChild();
            this.cubeDimensions.put(new CubeDimensionKey(c.getName(), cd.getName()), cd);
            if (e.getChild() instanceof MondrianModel.DimensionUsage) {
                MondrianModel.DimensionUsage du = (MondrianModel.DimensionUsage)e.getChild();
                this.addToDimensionUsagesMap(du);
            }
        } else if (e.getChild() instanceof MondrianModel.Dimension) {
            MondrianModel.Dimension d = (MondrianModel.Dimension)e.getChild();
            this.publicDimensions.put(d.getName().toLowerCase(), d);
        } else if (e.getChild() instanceof MondrianModel.Cube) {
            MondrianModel.Cube c = (MondrianModel.Cube)e.getChild();
            this.cubes.put(c.getName().toLowerCase(), c);
            for (MondrianModel.CubeDimension cd : c.getDimensions()) {
                this.cubeDimensions.put(new CubeDimensionKey(c.getName(), cd.getName()), cd);
                if (!(e.getChild() instanceof MondrianModel.DimensionUsage)) continue;
                MondrianModel.DimensionUsage du = (MondrianModel.DimensionUsage)e.getChild();
                this.addToDimensionUsagesMap(du);
            }
        } else if (e.getChild() instanceof MondrianModel.VirtualCubeDimension) {
            MondrianModel.VirtualCubeDimension vcd = (MondrianModel.VirtualCubeDimension)e.getChild();
            this.addToVCubeDimensionsMap(vcd);
        } else if (e.getChild() instanceof MondrianModel.CubeUsage) {
            MondrianModel.CubeUsage cu = (MondrianModel.CubeUsage)e.getChild();
            this.addToCubeUsagesMap(cu);
        } else if (e.getChild() instanceof MondrianModel.VirtualCube) {
            MondrianModel.VirtualCube vc = (MondrianModel.VirtualCube)e.getChild();
            this.vCubes.put(vc.getName().toLowerCase(), vc);
            MondrianModel.CubeUsages cubeUsages = vc.getCubeUsage();
            if (cubeUsages != null) {
                for (MondrianModel.CubeUsage cu : cubeUsages.getCubeUsages()) {
                    this.addToCubeUsagesMap(cu);
                }
                SQLPowerUtils.listenToHierarchy((SPObject)cubeUsages, (SPListener)this);
            }
            vc.addSPListener(this);
        }
        SQLPowerUtils.listenToHierarchy((SPObject)e.getChild(), (SPListener)this);
    }

    public void childRemoved(SPChildEvent e) {
        if (e.getSource() instanceof MondrianModel.Cube && e.getChild() instanceof MondrianModel.CubeDimension) {
            MondrianModel.CubeDimension cd = (MondrianModel.CubeDimension)e.getChild();
            MondrianModel.Cube c = (MondrianModel.Cube)e.getSource();
            this.cubeDimensions.remove(new CubeDimensionKey(c.getName(), cd.getName()));
            List<MondrianModel.VirtualCubeDimension> vCubeDims = this.vCubeDimensionMap.get((Object)cd);
            if (vCubeDims != null) {
                for (MondrianModel.VirtualCubeDimension vcd : new ArrayList<MondrianModel.VirtualCubeDimension>(vCubeDims)) {
                    MondrianModel.VirtualCube vCube = (MondrianModel.VirtualCube)vcd.getParent();
                    vCube.removeDimension(vcd);
                }
            }
            this.vCubeDimensionMap.remove((Object)cd);
            if (e.getChild() instanceof MondrianModel.DimensionUsage) {
                MondrianModel.DimensionUsage du = (MondrianModel.DimensionUsage)e.getChild();
                for (List<MondrianModel.DimensionUsage> dimUsages : this.dimensionUsageMap.values()) {
                    dimUsages.remove((Object)du);
                }
            }
        } else if (e.getChild() instanceof MondrianModel.Dimension) {
            MondrianModel.Dimension dim = (MondrianModel.Dimension)e.getChild();
            this.publicDimensions.remove(dim.getName().toLowerCase());
            List<MondrianModel.DimensionUsage> dimUsages = this.dimensionUsageMap.get((Object)dim);
            if (dimUsages != null) {
                for (MondrianModel.DimensionUsage du : new ArrayList<MondrianModel.DimensionUsage>(dimUsages)) {
                    MondrianModel.Cube c = (MondrianModel.Cube)du.getParent();
                    c.removeDimension(du);
                }
            }
            this.dimensionUsageMap.remove((Object)dim);
            List<MondrianModel.VirtualCubeDimension> vCubeDims = this.vCubeDimensionMap.get((Object)dim);
            if (vCubeDims != null) {
                for (MondrianModel.VirtualCubeDimension vcd : new ArrayList<MondrianModel.VirtualCubeDimension>(vCubeDims)) {
                    MondrianModel.VirtualCube vCube = (MondrianModel.VirtualCube)vcd.getParent();
                    vCube.removeDimension(vcd);
                }
            }
            this.vCubeDimensionMap.remove((Object)dim);
        } else if (e.getChild() instanceof MondrianModel.Cube) {
            MondrianModel.Cube cube = (MondrianModel.Cube)e.getChild();
            this.cubes.remove(cube.getName().toLowerCase());
            List<MondrianModel.CubeUsage> cubeUsages = this.cubeUsageMap.get((Object)cube);
            if (cubeUsages != null) {
                for (MondrianModel.CubeUsage cu : new ArrayList<MondrianModel.CubeUsage>(cubeUsages)) {
                    MondrianModel.CubeUsages c = (MondrianModel.CubeUsages)cu.getParent();
                    c.removeCubeUsage(cu);
                }
            }
            this.cubeUsageMap.remove((Object)cube);
            for (MondrianModel.CubeDimension cd : cube.getDimensions()) {
                List<MondrianModel.VirtualCubeDimension> vCubeDims = this.vCubeDimensionMap.get((Object)cd);
                if (vCubeDims != null) {
                    for (MondrianModel.VirtualCubeDimension vcd : new ArrayList<MondrianModel.VirtualCubeDimension>(vCubeDims)) {
                        MondrianModel.VirtualCube vCube = (MondrianModel.VirtualCube)vcd.getParent();
                        vCube.removeDimension(vcd);
                    }
                }
                this.vCubeDimensionMap.remove((Object)cd);
            }
        } else if (e.getChild() instanceof MondrianModel.CubeUsage) {
            MondrianModel.CubeUsage cu = (MondrianModel.CubeUsage)e.getChild();
            for (List<MondrianModel.CubeUsage> cubeUsages : this.cubeUsageMap.values()) {
                cubeUsages.remove((Object)cu);
            }
        } else if (e.getChild() instanceof MondrianModel.VirtualCube) {
            MondrianModel.VirtualCube vc = (MondrianModel.VirtualCube)e.getChild();
            this.vCubes.remove(vc.getName().toLowerCase());
            MondrianModel.CubeUsages cubeUsages = vc.getCubeUsage();
            if (cubeUsages != null) {
                for (List<MondrianModel.CubeUsage> usagesList : this.cubeUsageMap.values()) {
                    usagesList.removeAll(cubeUsages.getCubeUsages());
                }
                SQLPowerUtils.unlistenToHierarchy((SPObject)cubeUsages, (SPListener)this);
            }
            vc.removeSPListener(this);
        } else if (e.getChild() instanceof MondrianModel.VirtualCubeDimension) {
            for (List<MondrianModel.VirtualCubeDimension> vCubeDims : this.vCubeDimensionMap.values()) {
                vCubeDims.remove(e.getChild());
            }
        }
        SQLPowerUtils.unlistenToHierarchy((SPObject)e.getChild(), (SPListener)this);
    }

    public void propertyChanged(PropertyChangeEvent evt) {
        if ("cubeUsage".equals(evt.getPropertyName())) {
            MondrianModel.CubeUsages oldUsages = (MondrianModel.CubeUsages)((Object)evt.getOldValue());
            MondrianModel.CubeUsages newUsages = (MondrianModel.CubeUsages)((Object)evt.getNewValue());
            if (oldUsages != null) {
                for (List list : this.cubeUsageMap.values()) {
                    list.removeAll(oldUsages.getCubeUsages());
                }
                SQLPowerUtils.unlistenToHierarchy((SPObject)oldUsages, (SPListener)this);
            }
            if (newUsages != null) {
                for (MondrianModel.CubeUsage cubeUsage : newUsages.getCubeUsages()) {
                    this.addToCubeUsagesMap(cubeUsage);
                }
                SQLPowerUtils.listenToHierarchy((SPObject)newUsages, (SPListener)this);
            }
        } else if ("name".equals(evt.getPropertyName())) {
            if (evt.getSource() instanceof MondrianModel.Dimension) {
                MondrianModel.Dimension dim = (MondrianModel.Dimension)((Object)evt.getSource());
                String oldName = (String)evt.getOldValue();
                String newName = (String)evt.getNewValue();
                if (dim.getParent() instanceof MondrianModel.Schema) {
                    List<MondrianModel.DimensionUsage> list = this.dimensionUsageMap.get((Object)dim);
                    if (list != null) {
                        for (MondrianModel.DimensionUsage du : list) {
                            du.setSource(newName);
                            du.setName(newName);
                        }
                    }
                    this.publicDimensions.remove(oldName.toLowerCase());
                    this.publicDimensions.put(newName.toLowerCase(), dim);
                } else if (dim.getParent() instanceof MondrianModel.Cube) {
                    String string = dim.getParent().getName();
                    this.cubeDimensions.remove(new CubeDimensionKey(string, dim.getName()));
                    this.cubeDimensions.put(new CubeDimensionKey(string, newName), dim);
                } else {
                    logger.warn((Object)("Unexpected parent of " + (Object)((Object)dim) + " :" + dim.getParent()));
                }
                List<MondrianModel.VirtualCubeDimension> list = this.vCubeDimensionMap.get((Object)dim);
                if (list != null) {
                    for (MondrianModel.VirtualCubeDimension vcd : list) {
                        vcd.setName((String)evt.getNewValue());
                    }
                }
            } else if (evt.getSource() instanceof MondrianModel.Cube) {
                MondrianModel.Cube cube = (MondrianModel.Cube)((Object)evt.getSource());
                String oldName = (String)evt.getOldValue();
                String newName = (String)evt.getNewValue();
                for (MondrianModel.CubeDimension cubeDim : cube.getDimensions()) {
                    List<MondrianModel.VirtualCubeDimension> vCubeDims = this.vCubeDimensionMap.get((Object)cubeDim);
                    if (vCubeDims == null) continue;
                    for (MondrianModel.VirtualCubeDimension vcd : vCubeDims) {
                        vcd.setCubeName(newName);
                    }
                }
                List<MondrianModel.CubeUsage> list = this.cubeUsageMap.get((Object)cube);
                if (list != null) {
                    for (MondrianModel.CubeUsage cu : list) {
                        cu.setCubeName(newName);
                    }
                }
                this.cubes.remove(oldName.toLowerCase());
                this.cubes.put(newName.toLowerCase(), cube);
            } else if (evt.getSource() instanceof MondrianModel.VirtualCube) {
                MondrianModel.VirtualCube vCube = (MondrianModel.VirtualCube)((Object)evt.getSource());
                String oldName = (String)evt.getOldValue();
                String newName = (String)evt.getNewValue();
                this.vCubes.remove(oldName.toLowerCase());
                this.vCubes.put(newName.toLowerCase(), vCube);
            }
        }
    }

    public void transactionEnded(TransactionEvent e) {
    }

    public void transactionRollback(TransactionEvent e) {
    }

    public void transactionStarted(TransactionEvent e) {
    }

    private class CubeDimensionKey {
        private final String cubeName;
        private final String dimensionName;

        public CubeDimensionKey(String cubeName, String dimensionName) {
            this.cubeName = cubeName.toLowerCase();
            this.dimensionName = dimensionName.toLowerCase();
        }

        public String getCubeName() {
            return this.cubeName;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CubeDimensionKey)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            CubeDimensionKey other = (CubeDimensionKey)obj;
            if (this.getCubeName() == null ? other.getCubeName() != null : !this.getCubeName().equals(other.getCubeName())) {
                return false;
            }
            return !(this.getDimensionName() == null ? other.getDimensionName() != null : !this.getDimensionName().equals(other.getDimensionName()));
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 0;
            result = 31 * result + (this.getCubeName() == null ? 0 : this.getCubeName().hashCode());
            result = 31 * result + (this.getDimensionName() == null ? 0 : this.getDimensionName().hashCode());
            return result;
        }

        public String toString() {
            return this.getCubeName() + "." + this.getDimensionName();
        }
    }
}

