/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.uniquerows;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.uniquerows.Messages;
import org.pentaho.di.trans.steps.uniquerows.UniqueRowsData;
import org.pentaho.di.trans.steps.uniquerows.UniqueRowsMeta;

public class UniqueRows
extends BaseStep
implements StepInterface {
    private UniqueRowsMeta meta = (UniqueRowsMeta)this.getStepMeta().getStepMetaInterface();
    private UniqueRowsData data;

    public UniqueRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (UniqueRowsData)stepDataInterface;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (UniqueRowsMeta)smi;
        this.data = (UniqueRowsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            if (this.data.previous != null) {
                Object[] outputRow = this.addCounter(this.data.outputRowMeta, this.data.previous, this.data.counter);
                this.putRow(this.data.outputRowMeta, outputRow);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            this.data.compareRowMeta = this.getInputRowMeta().clone();
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.previous = this.data.inputRowMeta.cloneRow(r);
            this.data.fieldnrs = new int[this.meta.getCompareFields().length];
            for (int i = 0; i < this.meta.getCompareFields().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getCompareFields()[i]);
                if (this.data.fieldnrs[i] < 0) {
                    this.logError(Messages.getString("UniqueRows.Log.CouldNotFindFieldInRow", this.meta.getCompareFields()[i]));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.compareRowMeta.getValueMeta(this.data.fieldnrs[i]).setCaseInsensitive(this.meta.getCaseInsensitive()[i]);
            }
        }
        boolean isEqual = false;
        if (this.meta.getCompareFields() == null || this.meta.getCompareFields().length == 0) {
            isEqual = this.data.outputRowMeta.compare(r, this.data.previous) == 0;
        } else {
            boolean bl = isEqual = this.data.outputRowMeta.compare(r, this.data.previous, this.data.fieldnrs) == 0;
        }
        if (!isEqual) {
            Object[] outputRow = this.addCounter(this.data.outputRowMeta, this.data.previous, this.data.counter);
            this.putRow(this.data.outputRowMeta, outputRow);
            this.data.previous = this.data.inputRowMeta.cloneRow(r);
            this.data.counter = 1L;
        } else {
            ++this.data.counter;
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(Messages.getString("UniqueRows.Log.LineNumber") + this.getLinesRead());
        }
        return true;
    }

    private Object[] addCounter(RowMetaInterface outputRowMeta, Object[] r, long count) {
        if (this.meta.isCountRows()) {
            Object[] outputRow = RowDataUtil.addValueData((Object[])r, (int)(outputRowMeta.size() - 1), (Object)new Long(count));
            return outputRow;
        }
        return r;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UniqueRowsMeta)smi;
        this.data = (UniqueRowsData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

