/* SPDX-FileCopyrightText: 2002 - Paolo Maggi
 * SPDX-FileCopyrightText: 2015 - Sébastien Wilmet
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GSPELL_H_INSIDE) && !defined (GSPELL_COMPILATION)
#error "Only <gspell/gspell.h> can be included directly."
#endif

#include <gtk/gtk.h>
#include <gspell/gspell-navigator.h>

G_BEGIN_DECLS

#define GSPELL_TYPE_CHECKER_DIALOG (gspell_checker_dialog_get_type ())

G_MODULE_EXPORT
G_DECLARE_DERIVABLE_TYPE (GspellCheckerDialog, gspell_checker_dialog,
			  GSPELL, CHECKER_DIALOG,
			  GtkDialog)

struct _GspellCheckerDialogClass
{
	GtkDialogClass parent_class;

	/* Padding for future expansion */
	gpointer padding[8];
};

G_MODULE_EXPORT
GtkWidget *		gspell_checker_dialog_new			(GtkWindow       *parent,
									 GspellNavigator *navigator);

G_MODULE_EXPORT
GspellNavigator *	gspell_checker_dialog_get_spell_navigator	(GspellCheckerDialog *dialog);

G_END_DECLS
