/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class UTMFranceDOMProjectionChoice
extends ListProjectionChoice {
    private static final String FORT_MARIGOT_NAME = I18n.tr("Guadeloupe Fort-Marigot 1949", new Object[0]);
    private static final String SAINTE_ANNE_NAME = I18n.tr("Guadeloupe Ste-Anne 1948", new Object[0]);
    private static final String MARTINIQUE_NAME = I18n.tr("Martinique Fort Desaix 1952", new Object[0]);
    private static final String REUNION_92_NAME = I18n.tr("Reunion RGR92", new Object[0]);
    private static final String GUYANE_92_NAME = I18n.tr("Guyane RGFG95", new Object[0]);
    private static final String[] UTM_GEODESIC_NAMES = new String[]{FORT_MARIGOT_NAME, SAINTE_ANNE_NAME, MARTINIQUE_NAME, REUNION_92_NAME, GUYANE_92_NAME};
    private static final Integer FORT_MARIGOT_EPSG = 2969;
    private static final Integer SAINTE_ANNE_EPSG = 2970;
    private static final Integer MARTINIQUE_EPSG = 2973;
    private static final Integer REUNION_EPSG = 2975;
    private static final Integer GUYANE_EPSG = 2972;
    private static final Integer[] UTM_EPSGS = new Integer[]{FORT_MARIGOT_EPSG, SAINTE_ANNE_EPSG, MARTINIQUE_EPSG, REUNION_EPSG, GUYANE_EPSG};

    public UTMFranceDOMProjectionChoice() {
        super(I18n.tr("UTM France (DOM)", new Object[0]), "core:utmfrancedom", UTM_GEODESIC_NAMES, I18n.tr("UTM Geodesic system", new Object[0]));
    }

    @Override
    protected String indexToZone(int index) {
        return Integer.toString(index + 1);
    }

    @Override
    protected int zoneToIndex(String zone) {
        try {
            return Integer.parseInt(zone) - 1;
        }
        catch (NumberFormatException e) {
            Logging.warn(e);
            return this.defaultIndex;
        }
    }

    @Override
    public String getProjectionName() {
        return UTM_GEODESIC_NAMES[this.index];
    }

    @Override
    public String getCurrentCode() {
        return "EPSG:" + UTM_EPSGS[this.index];
    }

    @Override
    public String[] allCodes() {
        return (String[])Arrays.stream(UTM_EPSGS).map(utmEpsg -> "EPSG:" + utmEpsg).toArray(String[]::new);
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        for (int i = 0; i < UTM_EPSGS.length; ++i) {
            if (!("EPSG:" + UTM_EPSGS[i]).equals(code)) continue;
            return Collections.singleton(Integer.toString(i + 1));
        }
        return null;
    }
}

