/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxLoc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR_DATA;
    public static final int INT_DATA;

    public CXIdxLoc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxLoc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *[2]")
    public PointerBuffer ptr_data() {
        return CXIdxLoc.nptr_data(this.address());
    }

    @NativeType(value="void *")
    public long ptr_data(int index) {
        return CXIdxLoc.nptr_data(this.address(), index);
    }

    @NativeType(value="unsigned")
    public int int_data() {
        return CXIdxLoc.nint_data(this.address());
    }

    public static CXIdxLoc malloc() {
        return (CXIdxLoc)CXIdxLoc.wrap(CXIdxLoc.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CXIdxLoc calloc() {
        return (CXIdxLoc)CXIdxLoc.wrap(CXIdxLoc.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CXIdxLoc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CXIdxLoc)CXIdxLoc.wrap(CXIdxLoc.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CXIdxLoc create(long address) {
        return (CXIdxLoc)CXIdxLoc.wrap(CXIdxLoc.class, (long)address);
    }

    @Nullable
    public static CXIdxLoc createSafe(long address) {
        return address == 0L ? null : (CXIdxLoc)CXIdxLoc.wrap(CXIdxLoc.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CXIdxLoc.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CXIdxLoc.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CXIdxLoc.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXIdxLoc.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CXIdxLoc.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXIdxLoc.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXIdxLoc.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static CXIdxLoc mallocStack() {
        return CXIdxLoc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxLoc callocStack() {
        return CXIdxLoc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXIdxLoc mallocStack(MemoryStack stack) {
        return CXIdxLoc.malloc(stack);
    }

    @Deprecated
    public static CXIdxLoc callocStack(MemoryStack stack) {
        return CXIdxLoc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXIdxLoc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXIdxLoc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXIdxLoc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXIdxLoc.calloc(capacity, stack);
    }

    public static CXIdxLoc malloc(MemoryStack stack) {
        return (CXIdxLoc)CXIdxLoc.wrap(CXIdxLoc.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXIdxLoc calloc(MemoryStack stack) {
        return (CXIdxLoc)CXIdxLoc.wrap(CXIdxLoc.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxLoc.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CXIdxLoc.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static PointerBuffer nptr_data(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)PTR_DATA), (int)2);
    }

    public static long nptr_data(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PTR_DATA + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    public static int nint_data(long struct) {
        return UNSAFE.getInt(null, struct + (long)INT_DATA);
    }

    static {
        Struct.Layout layout = CXIdxLoc.__struct((Struct.Member[])new Struct.Member[]{CXIdxLoc.__array((int)POINTER_SIZE, (int)2), CXIdxLoc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR_DATA = layout.offsetof(0);
        INT_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXIdxLoc, Buffer>
    implements NativeResource {
        private static final CXIdxLoc ELEMENT_FACTORY = CXIdxLoc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxLoc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *[2]")
        public PointerBuffer ptr_data() {
            return CXIdxLoc.nptr_data(this.address());
        }

        @NativeType(value="void *")
        public long ptr_data(int index) {
            return CXIdxLoc.nptr_data(this.address(), index);
        }

        @NativeType(value="unsigned")
        public int int_data() {
            return CXIdxLoc.nint_data(this.address());
        }
    }
}

