/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.osgi.util.converter.ConverterFunction;
import org.osgi.util.converter.TargetRule;
import org.osgi.util.function.Function;

public abstract class Rule<F, T>
implements TargetRule {
    private final ConverterFunction function;

    public Rule(Function<F, T> func) {
        this.function = this.getGenericFunction(func);
    }

    private ConverterFunction getGenericFunction(final Function<F, T> func) {
        return new ConverterFunction(){

            @Override
            public Object apply(Object obj, Type targetType) throws Exception {
                Rule r = Rule.this;
                Type type = ((ParameterizedType)r.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                Class cls = null;
                if (!(type instanceof Class)) {
                    return ConverterFunction.CANNOT_HANDLE;
                }
                cls = (Class)type;
                if (cls.isInstance(obj)) {
                    return func.apply(obj);
                }
                return ConverterFunction.CANNOT_HANDLE;
            }
        };
    }

    @Override
    public ConverterFunction getFunction() {
        return this.function;
    }

    @Override
    public Type getTargetType() {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        return type;
    }
}

