/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.interceptors;

import java.net.SocketAddress;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.interceptors.MessageInterceptorAdapter;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OriginTracer
extends MessageInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginTracer.class);

    @Override
    public void receiveRequest(Request request) {
        LOGGER.trace("{}", StringUtil.toLog((SocketAddress)request.getSourceContext().getPeerAddress()));
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message) {
        if (message.getType() == CoAP.Type.CON) {
            LOGGER.trace("{}", StringUtil.toLog((SocketAddress)message.getSourceContext().getPeerAddress()));
        }
    }
}

