/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.dispatch.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.OpenHAB;
import org.openhab.core.config.dispatch.internal.ConfigDispatcher;
import org.openhab.core.service.WatchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@NonNullByDefault
public class ConfigDispatcherFileWatcher
implements WatchService.WatchEventListener {
    public static final String SERVICEDIR_PROG_ARGUMENT = "openhab.servicedir";
    public static final String SERVICES_FOLDER = "services";
    private final Logger logger = LoggerFactory.getLogger(ConfigDispatcherFileWatcher.class);
    private final ConfigDispatcher configDispatcher;
    private final WatchService watchService;

    @Activate
    public ConfigDispatcherFileWatcher(@Reference ConfigDispatcher configDispatcher, @Reference(target="(watchservice.name=configWatcher)") WatchService watchService) {
        this.configDispatcher = configDispatcher;
        String servicesFolder = System.getProperty(SERVICEDIR_PROG_ARGUMENT, SERVICES_FOLDER);
        this.watchService = watchService;
        watchService.registerListener((WatchService.WatchEventListener)this, Path.of(servicesFolder, new String[0]), false);
        configDispatcher.processConfigFile(Path.of(OpenHAB.getConfigFolder(), servicesFolder).toFile());
    }

    @Deactivate
    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
    }

    public void processWatchEvent(WatchService.Kind kind, Path fullPath) {
        try {
            if (kind == WatchService.Kind.CREATE || kind == WatchService.Kind.MODIFY) {
                if (!Files.isHidden(fullPath) && fullPath.toString().endsWith(".cfg")) {
                    this.configDispatcher.processConfigFile(fullPath.toFile());
                }
            } else if (kind == WatchService.Kind.DELETE) {
                if (!fullPath.toString().endsWith(".cfg")) {
                    return;
                }
                this.configDispatcher.fileRemoved(fullPath.toString());
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to process watch event {} for {}", new Object[]{kind, fullPath, e});
        }
    }
}

