/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.common.types.access.binary.asm.AbstractBinarySignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryGenericTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeParameter;
import org.eclipse.xtext.common.types.access.binary.asm.SignatureUtil;

public class BinarySuperTypeSignature
extends AbstractBinarySignature {
    BinarySuperTypeSignature(String chars) {
        super(chars);
    }

    public List<BinaryGenericTypeSignature> getSuperTypes() {
        int index = this.offset;
        if (this.chars.charAt(this.offset) == '<') {
            int count = 1;
            while (count > 0 && ++index < this.offset + this.length) {
                switch (this.chars.charAt(index)) {
                    case '<': {
                        ++count;
                        break;
                    }
                    case '>': {
                        --count;
                    }
                }
            }
            ++index;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)2);
        while (index != this.offset + this.length) {
            int end = SignatureUtil.scanTypeSignature(this.chars, index) + 1;
            result.add(new BinaryGenericTypeSignature(this.chars, index, end - index));
            index = end;
        }
        return result;
    }

    @Override
    public List<BinaryTypeParameter> getTypeParameters() {
        return this.doGetTypeParameters();
    }
}

