/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.cpu;

import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.visualvm.lib.jfluid.results.ExportDataDumper;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.cpu.CCTDisplay;
import org.graalvm.visualvm.lib.ui.cpu.ScreenshotProvider;
import org.graalvm.visualvm.lib.ui.cpu.SnapshotFlatProfilePanel;

public class CombinedPanel
extends JSplitPane
implements ScreenshotProvider {
    public CombinedPanel(int splitOrientation, Component component1, Component component2) {
        super(splitOrientation, component1, component2);
        this.tweakUI();
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, String viewName) {
        ((CCTDisplay)this.leftComponent).exportData(exportedFileType, eDD, true, viewName);
        ((SnapshotFlatProfilePanel)this.rightComponent).exportData(exportedFileType, eDD, true, viewName);
    }

    @Override
    public BufferedImage getCurrentViewScreenshot(boolean onlyVisible) {
        return UIUtils.createScreenshot(this);
    }

    @Override
    public String getDefaultViewName() {
        return "cpu-combined";
    }

    @Override
    public boolean fitsVisibleArea() {
        return true;
    }

    private void tweakUI() {
        this.setBorder(null);
        this.setDividerSize(5);
        if (!(this.getUI() instanceof BasicSplitPaneUI)) {
            return;
        }
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        if (divider != null) {
            Color c = UIUtils.isNimbus() ? UIUtils.getDisabledLineColor() : new JSeparator().getForeground();
            divider.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, c));
        }
    }
}

