/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.Set;
import javax.net.ssl.SSLSocket;

class SSLSocketChannel
extends SocketChannel {
    private final SSLSocket _socket;

    public SSLSocketChannel(SSLSocket socket) {
        super(SelectorProvider.provider());
        this._socket = socket;
    }

    @Override
    public Socket socket() {
        return this._socket;
    }

    @Override
    public boolean connect(SocketAddress remote) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean finishConnect() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return this._socket.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return false;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._socket.getRemoteSocketAddress();
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        this._socket.getInputStream().close();
        return this;
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        this._socket.getOutputStream().close();
        return this;
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> name, T value) {
        return this;
    }

    @Override
    public SocketChannel bind(SocketAddress local) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer src) throws IOException {
        if (!src.hasArray()) {
            throw new UnsupportedOperationException();
        }
        int pos = src.position();
        int len = src.remaining();
        int read = this._socket.getInputStream().read(src.array(), src.arrayOffset() + pos, len);
        if (read > 0) {
            src.position(pos + read);
        }
        return read;
    }

    @Override
    public long read(ByteBuffer[] srcs, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!src.hasArray()) {
            throw new UnsupportedOperationException();
        }
        int pos = src.position();
        int len = src.remaining();
        this._socket.getOutputStream().write(src.array(), src.arrayOffset() + pos, len);
        src.position(pos + len);
        return len;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void implCloseSelectableChannel() throws IOException {
        this._socket.close();
    }

    @Override
    public void implConfigureBlocking(boolean block) throws IOException {
        if (!block) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._socket.getLocalSocketAddress();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) {
        return null;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return Collections.emptySet();
    }
}

