/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.common.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import java.util.function.Predicate;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

public class JaxrsMethodsProcessor {
    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem jaxrsMethods(BeanArchiveIndexBuildItem beanArchiveIndex) {
        final IndexView index = beanArchiveIndex.getIndex();
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                if (method.declaringClass().hasDeclaredAnnotation(ResteasyReactiveDotNames.PATH)) {
                    return true;
                }
                if (this.isJaxrsResourceMethod(method)) {
                    return true;
                }
                for (Type interfaceType : method.declaringClass().interfaceTypes()) {
                    ClassInfo interfaceInfo = index.getClassByName(interfaceType.name());
                    if (interfaceInfo == null) continue;
                    if (interfaceInfo.hasDeclaredAnnotation(ResteasyReactiveDotNames.PATH)) {
                        return true;
                    }
                    MethodInfo overriddenMethodInfo = interfaceInfo.method(method.name(), method.parameterTypes().toArray(new Type[0]));
                    if (overriddenMethodInfo == null || !this.isJaxrsResourceMethod(overriddenMethodInfo)) continue;
                    return true;
                }
                return false;
            }

            private boolean isJaxrsResourceMethod(MethodInfo method) {
                return method.hasDeclaredAnnotation(ResteasyReactiveDotNames.PATH) || method.hasDeclaredAnnotation(ResteasyReactiveDotNames.GET) || method.hasDeclaredAnnotation(ResteasyReactiveDotNames.POST) || method.hasDeclaredAnnotation(ResteasyReactiveDotNames.PUT) || method.hasDeclaredAnnotation(ResteasyReactiveDotNames.DELETE) || method.hasDeclaredAnnotation(ResteasyReactiveDotNames.PATCH) || method.hasDeclaredAnnotation(ResteasyReactiveDotNames.HEAD) || method.hasDeclaredAnnotation(ResteasyReactiveDotNames.OPTIONS);
            }
        });
    }
}

