/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import com.google.common.io.CharStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.detachable.CompactStoredNodeModelReader;
import org.eclipse.xtext.nodemodel.detachable.CompactStoredNodeModelWriter;
import org.eclipse.xtext.nodemodel.detachable.DetachableNodeModelBuilder;
import org.eclipse.xtext.nodemodel.detachable.DetachableParseResultWrapper;
import org.eclipse.xtext.nodemodel.detachable.GrammarElementLookup;
import org.eclipse.xtext.nodemodel.detachable.Tabulated;
import org.eclipse.xtext.nodemodel.impl.NodeModelBuilder;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public class StorageAwareDetachableParseResultWrapper
extends DetachableParseResultWrapper {
    private static final Logger LOG = Logger.getLogger(DetachableParseResultWrapper.class);
    @Inject
    protected Provider<NodeModelBuilder> nodeModelBuilder;
    @Inject
    protected GrammarElementLookup grammarElementLookup;

    @Override
    public boolean customWriteNodeModel(XtextResource resource, OutputStream outputStream) throws IOException {
        IParseResult parseResult = resource.getParseResult();
        EObject rootElement = parseResult.getRootASTElement();
        Tabulated<EObject> semanticObjects = this.semanticObjectIndex(rootElement);
        CompactStoredNodeModelWriter writer = new CompactStoredNodeModelWriter(outputStream, semanticObjects, this.grammarElementLookup);
        RootNode rootNode = (RootNode)parseResult.getRootNode();
        writer.writeNode(rootNode);
        writer.flush();
        return true;
    }

    protected Tabulated<EObject> semanticObjectIndex(EObject rootElement) {
        Tabulated<EObject> semanticObjects = new Tabulated<EObject>();
        TreeIterator<EObject> iterator = EcoreUtil2.eAll(rootElement);
        while (iterator.hasNext()) {
            semanticObjects.getId((EObject)iterator.next());
        }
        return semanticObjects;
    }

    @Override
    public boolean customReadNodeModel(XtextResource resource, InputStream inputStream) throws IOException {
        URI uri;
        URIConverter uriConverter = resource.getResourceSet().getURIConverter();
        if (!uriConverter.exists(uri = resource.getURI(), resource.getResourceSet().getLoadOptions())) {
            LOG.info((Object)("Skipping loading node model for synthetic resource " + String.valueOf(uri)));
            return false;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStreamReader reader = new InputStreamReader(uriConverter.createInputStream(uri), resource.getEncoding());){
            String completeContent = CharStreams.toString((Readable)reader);
            DetachableNodeModelBuilder builder = (DetachableNodeModelBuilder)this.nodeModelBuilder.get();
            EObject semanticRoot = (EObject)resource.getContents().get(0);
            Tabulated<EObject> semanticObjects = this.semanticObjectIndex(semanticRoot);
            CompactStoredNodeModelReader nodeModelReader = new CompactStoredNodeModelReader(inputStream, completeContent, semanticObjects, builder, this.grammarElementLookup);
            RootNode rootNode = (RootNode)nodeModelReader.readNode();
            IParseResult parseResult = builder.createParseResult(semanticRoot, rootNode, nodeModelReader.hasErrors());
            resource.setParseResult(parseResult);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }
}

