/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mqtt.internal.client;

import com.hivemq.client.mqtt.MqttClientState;
import com.hivemq.client.mqtt.datatypes.MqttQos;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.mqtt.MqttWillAndTestament;
import org.openhab.core.io.transport.mqtt.internal.Subscription;

@NonNullByDefault
public abstract class MqttAsyncClientWrapper
implements HostnameVerifier {
    public abstract CompletableFuture<?> connect(@Nullable MqttWillAndTestament var1, int var2, @Nullable String var3, @Nullable String var4);

    public abstract CompletableFuture<Void> disconnect();

    public abstract MqttClientState getState();

    public abstract CompletableFuture<?> publish(String var1, byte[] var2, boolean var3, int var4);

    public abstract CompletableFuture<?> subscribe(String var1, int var2, Subscription var3);

    public abstract CompletableFuture<?> unsubscribe(String var1);

    protected MqttQos getMqttQosFromInt(int qos) {
        switch (qos) {
            case 0: {
                return MqttQos.AT_MOST_ONCE;
            }
            case 1: {
                return MqttQos.AT_LEAST_ONCE;
            }
            case 2: {
                return MqttQos.EXACTLY_ONCE;
            }
        }
        throw new IllegalArgumentException("QoS needs to be 0, 1 or 2.");
    }

    @Override
    public boolean verify(@Nullable String hostname, @Nullable SSLSession sslSession) {
        return true;
    }
}

