/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class HoverTypeAdapter
extends TypeAdapter<Hover> {
    private static final TypeToken<List<Either<String, MarkedString>>> LIST_STRING_MARKEDSTRING = new TypeToken<List<Either<String, MarkedString>>>(){};
    private static final TypeToken<Either<String, MarkedString>> STRING_MARKEDSTRING = new TypeToken<Either<String, MarkedString>>(){};
    private static final TypeToken<Either<List<Either<String, MarkedString>>, MarkupContent>> CONTENTS_TYPE_TOKEN = new TypeToken<Either<List<Either<String, MarkedString>>, MarkupContent>>(){};
    private final Gson gson;

    protected Either<List<Either<String, MarkedString>>, MarkupContent> readContents(JsonReader in) throws IOException {
        JsonToken nextToken = in.peek();
        if (nextToken == JsonToken.STRING) {
            ArrayList<Either> value = new ArrayList<Either>();
            value.add(Either.forLeft((Object)in.nextString()));
            return Either.forLeft(value);
        }
        if (nextToken == JsonToken.BEGIN_ARRAY) {
            List value_1 = (List)this.gson.fromJson(in, LIST_STRING_MARKEDSTRING.getType());
            return Either.forLeft((Object)value_1);
        }
        JsonElement _parseReader = JsonParser.parseReader((JsonReader)in);
        JsonObject object = (JsonObject)_parseReader;
        boolean _has = object.has("language");
        if (_has) {
            ArrayList<Either> value_2 = new ArrayList<Either>();
            value_2.add(Either.forRight((Object)((MarkedString)this.gson.fromJson((JsonElement)object, MarkedString.class))));
            return Either.forLeft(value_2);
        }
        return Either.forRight((Object)((MarkupContent)this.gson.fromJson((JsonElement)object, MarkupContent.class)));
    }

    protected void writeContents(JsonWriter out, Either<List<Either<String, MarkedString>>, MarkupContent> contents) throws IOException {
        boolean _isLeft = contents.isLeft();
        if (_isLeft) {
            boolean _equals;
            List list = (List)contents.getLeft();
            int _size = list.size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                this.gson.toJson(list.get(0), STRING_MARKEDSTRING.getType(), out);
            } else {
                this.gson.toJson((Object)list, LIST_STRING_MARKEDSTRING.getType(), out);
            }
        } else {
            this.gson.toJson(contents.getRight(), MarkupContent.class, out);
        }
    }

    public HoverTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public Hover read(JsonReader in) throws IOException {
        JsonToken nextToken = in.peek();
        if (nextToken == JsonToken.NULL) {
            return null;
        }
        Hover result = new Hover();
        in.beginObject();
        block8: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "contents": {
                    result.setContents(this.readContents(in));
                    continue block8;
                }
                case "range": {
                    result.setRange(this.readRange(in));
                    continue block8;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return result;
    }

    protected Range readRange(JsonReader in) throws IOException {
        return (Range)this.gson.fromJson(in, Range.class);
    }

    public void write(JsonWriter out, Hover value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        out.name("contents");
        this.writeContents(out, value.getContents());
        out.name("range");
        this.writeRange(out, value.getRange());
        out.endObject();
    }

    protected void writeRange(JsonWriter out, Range value) throws IOException {
        this.gson.toJson((Object)value, Range.class, out);
    }

    public static class Factory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Hover.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new HoverTypeAdapter(gson);
        }
    }
}

