/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(13, 26) << 0u) => ivec2(13, 26)
 * (ivec2(13, 26) << 1u) => ivec2(26, 52)
 * (ivec2(13, 26) << 2u) => ivec2(52, 104)
 * (ivec2(13, 26) << 5u) => ivec2(416, 832)
 * (ivec2(13, 26) << 25u) => ivec2(436207616, 872415232)
 * (ivec2(13, 26) << 31u) => ivec2(-2147483648, 0)
 * (ivec2(-2, 26) << 0u) => ivec2(-2, 26)
 * (ivec2(-2, 26) << 1u) => ivec2(-4, 52)
 * (ivec2(-2, 26) << 2u) => ivec2(-8, 104)
 * (ivec2(-2, 26) << 5u) => ivec2(-64, 832)
 * (ivec2(-2, 26) << 25u) => ivec2(-67108864, 872415232)
 * (ivec2(-2, 26) << 31u) => ivec2(0, 0)
 * (ivec2(2, 26) << 0u) => ivec2(2, 26)
 * (ivec2(2, 26) << 1u) => ivec2(4, 52)
 * (ivec2(2, 26) << 2u) => ivec2(8, 104)
 * (ivec2(2, 26) << 5u) => ivec2(64, 832)
 * (ivec2(2, 26) << 25u) => ivec2(67108864, 872415232)
 * (ivec2(2, 26) << 31u) => ivec2(0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec2(13, 26) << 0u), ivec2(13, 26))) ? 1 : -1] array0;
  float[all(equal((ivec2(13, 26) << 1u), ivec2(26, 52))) ? 1 : -1] array1;
  float[all(equal((ivec2(13, 26) << 2u), ivec2(52, 104))) ? 1 : -1] array2;
  float[all(equal((ivec2(13, 26) << 5u), ivec2(416, 832))) ? 1 : -1] array3;
  float[all(equal((ivec2(13, 26) << 25u), ivec2(436207616, 872415232))) ? 1 : -1] array4;
  float[all(equal((ivec2(13, 26) << 31u), ivec2(-2147483648, 0))) ? 1 : -1] array5;
  float[all(equal((ivec2(-2, 26) << 0u), ivec2(-2, 26))) ? 1 : -1] array6;
  float[all(equal((ivec2(-2, 26) << 1u), ivec2(-4, 52))) ? 1 : -1] array7;
  float[all(equal((ivec2(-2, 26) << 2u), ivec2(-8, 104))) ? 1 : -1] array8;
  float[all(equal((ivec2(-2, 26) << 5u), ivec2(-64, 832))) ? 1 : -1] array9;
  float[all(equal((ivec2(-2, 26) << 25u), ivec2(-67108864, 872415232))) ? 1 : -1] array10;
  float[all(equal((ivec2(-2, 26) << 31u), ivec2(0, 0))) ? 1 : -1] array11;
  float[all(equal((ivec2(2, 26) << 0u), ivec2(2, 26))) ? 1 : -1] array12;
  float[all(equal((ivec2(2, 26) << 1u), ivec2(4, 52))) ? 1 : -1] array13;
  float[all(equal((ivec2(2, 26) << 2u), ivec2(8, 104))) ? 1 : -1] array14;
  float[all(equal((ivec2(2, 26) << 5u), ivec2(64, 832))) ? 1 : -1] array15;
  float[all(equal((ivec2(2, 26) << 25u), ivec2(67108864, 872415232))) ? 1 : -1] array16;
  float[all(equal((ivec2(2, 26) << 31u), ivec2(0, 0))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
