# Debmake

This is the new debmake program written in Python.  This provides convenient
command to make a Debian package from the upstream VCS/tarball/source-tree.

This is available as the "debmake" package on Debian.

* Homepage: https://salsa.debian.org/debian/debmake
* Default branch: main

See the HTML files in the "debmake-doc" package for the introductory guide.

## General source structure

The `src/debmake/__main__.py` is provides the entry point and backbone of the
`debmake` command.  Its code flows as follows:

* `debmake.para.para` -- this is the command line parser
* `debmake.sanity.sanity` -- do some sanity checks for version etc.
* `debmake.dist.dist` -- run `make dist` or similar to get `tar.xz etc`.
* `debmake.tar.tar` -- if required, create `tar.xz` etc. excluding `debian/*`
* `debmake.untar.untar` -- untar `tar.xz`
* `debmake.origtar.origtar` -- create a link from `tar.xz` to `orig.tar.xz`
* `debmake.debs.debs` -- parse `-b` spec and return `para["debs"]`
* `debmake.analyze.analyze` -- analyze source tree to identify its build system
* `debmake.debian.debian` -- write out `debian/*` configuration files


## License for the entire source

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

### FILES outside of src/debmake/data/

* Copyright © 2013-2026 Osamu Aoki <osamu@debian.org>

### FILES inside of src/debmake/data/
* Copyright © Jim Van Zandt <jrv@debian.org>
* Copyright © Santiago Vila <sanvila@ctv.es>
* Copyright © Dirk Eddelbuettel <edd@debian.org>
* Copyright © Nils Naumann <naumann@unileoben.ac.at>
* Copyright © Jim Van Zandt <jrv@debian.org>
* Copyright © 2013-2026 Osamu Aoki <osamu@debian.org>

Some of these are originally generated by the output of the dh_make command.
The output has been edited by Osamu Aoki to fit into this package.  The dh-make
package came with the GPL license with the following permissive exception:

  As a special exception, when the template files are copied by dh-make into
  dh-make output files, you may use those output files without restriction.
  This special exception was added by Craig Small in version 0.37 of dh-make.

Since this exception is permissive, I am releasing the entire source package
under permissive MIT license as above.

### History

The author thanks previous efforts on this topic (GPL):
* debmake: command: deb-make, version up to 3.8         (shell script)
  * 1996-1997 Christoph Lameter <clameter@debian.org>
  * 1997-2006 Santiago Vila <sanvila@debian.org>
* dh-make: command: dh_make                             (perl script)
  * 1998-2012 Craig Small <csmall@debian.org>
    (This is active project in 2021.  Around 2016, dh-make was ported to
     python code base with major updates.)
* Since version 5.0.0 in 2026 of debmake, license check functionality is deligated to licensecheck

## How to install

Debian/Ubuntu package to a system:

    $ sudo apt-get install debmake

For other POSIX system, you can create a wheel package and install it with pip
in the virtual environment.  For example.

```sh
 $ mkdir -p path/to/venv
 $ python3 -m venv path/to/venv
 $ source path/to/venv/bin/activate
(venv) $ cd path/to/debmake
(venv) $ python3 -m build
(venv) $ pip install dist/debmake*.whl
```

## How to modify as contributor

1. Check-out default branch "main":
        $ git clone https://salsa.debian.org/debian/debmake.git
2. Make modification to "main" branch (or your private topic branch
   and send us your pull request or patch).

## How to update as upstream before release

1. Update `src/debmake/__init__.py` with new upstream version `4.1.2`
2. Add a new entry to the debian/changelog with the new upstream version
   ("`dch -i`" creates entry such as `4.1.1-2` --> change to `4.1.2-1`)
3. When debmake command line interface changes:
      * update debmake-doc package
      * generate a new `debmake.1` file in its source
      * copy generated `debmake.1` file into `manpages/debmake.1`
4. Tag it with upstream version `4.1.2` and build with
```
        $ git tag -s 4.1.2
        $ git deborig
	$ sbuild
```
5. Clean source tree with
```
        $ git clean -d -f -x
```

6. Make source only upload.
```
        $ dgit push-source
```

(Initial dgit transition needs more work with `--deliberately-not-fast-forward`
or `--overwrite`.  See dgit-maint-merge(7))

Please follow PEP-8 as much as possible.

* format source with "black" and "isort"
* check source with "pyright" if possible
* indent 4 spaces
* 80 char/line

## Debug the source code without installing it as deb package

The source code can be tested by installing its wheel package to your user's
venv environment.

```sh
 $ mkdir -p path/to/venv
 $ python3 -m venv path/to/venv
 $ source path/to/venv/bin/activate
(venv) $ pip install dist/debmake*.whl
```
Here, I install debmake module into a python virtual environment.

Now `debmake` script providing `debmake` equivalent command
can be executed from the command line for debugging.

```
$ debmake [-h] [-n | -a package-version.tar.gz | -d | -t]
```

There are other ways to test code in place without installing them.  One way is
to set up the module loading path `$PYTHONPATH` to `src/`; and the command
search path `$PATH` to be extended to include `src/debmake/` respectively from
where `setup.py` is found by sourcing as:

```sh
 $ source setenv
```

Script `./__main__.py` providing `/usr/bin/debmake` equivalent available under this
shell environment.

Since setting proper environment variables `$PATH` and `$PYTHONPATH` or
executing a command from a particular path are confusing, I don't recommend
testing code in place.

## Hints for reading the source

How copyright files are scanned by debmake in normal usage?

```
    normal execution     --> debmake/debian.py    debian()
                         +-> calling licensecheck to make debian/copyright
                         +-> other debian/* files made from template files
```

(PATH are relative to `src/`)

