/*
// $Id: //open/dev/farrago/src/org/eigenbase/sql2rel/SqlNodeToRexConverter.java#7 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2005-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.sql2rel;

import org.eigenbase.rex.*;
import org.eigenbase.sql.*;


/**
 * Converts expressions from {@link SqlNode} to {@link RexNode}.
 */
public interface SqlNodeToRexConverter
{
    //~ Methods ----------------------------------------------------------------

    /**
     * Converts a {@link SqlCall} to a {@link RexNode} expression.
     */
    RexNode convertCall(
        SqlRexContext cx,
        SqlCall call);

    /**
     * Converts a {@link SqlLiteral SQL literal} to a {@link RexLiteral REX
     * literal}.
     *
     * <p>The result is {@link RexNode}, not {@link RexLiteral} because if the
     * literal is NULL (or the boolean Unknown value), we make a <code>CAST(NULL
     * AS type)</code> expression.
     */
    RexNode convertLiteral(
        SqlRexContext cx,
        SqlLiteral literal);

    /**
     * Converts a {@link SqlIntervalQualifier SQL Interval Qualifier} to a
     * {@link RexLiteral REX literal}.
     */
    RexLiteral convertInterval(
        SqlRexContext cx,
        SqlIntervalQualifier intervalQualifier);
}

// End SqlNodeToRexConverter.java
