//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/advisor/armadvisor"
	"net/http"
	"net/url"
	"regexp"
)

// ConfigurationsServer is a fake server for instances of the armadvisor.ConfigurationsClient type.
type ConfigurationsServer struct {
	// CreateInResourceGroup is the fake for method ConfigurationsClient.CreateInResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	CreateInResourceGroup func(ctx context.Context, configurationName armadvisor.ConfigurationName, resourceGroup string, configContract armadvisor.ConfigData, options *armadvisor.ConfigurationsClientCreateInResourceGroupOptions) (resp azfake.Responder[armadvisor.ConfigurationsClientCreateInResourceGroupResponse], errResp azfake.ErrorResponder)

	// CreateInSubscription is the fake for method ConfigurationsClient.CreateInSubscription
	// HTTP status codes to indicate success: http.StatusOK
	CreateInSubscription func(ctx context.Context, configurationName armadvisor.ConfigurationName, configContract armadvisor.ConfigData, options *armadvisor.ConfigurationsClientCreateInSubscriptionOptions) (resp azfake.Responder[armadvisor.ConfigurationsClientCreateInSubscriptionResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method ConfigurationsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroup string, options *armadvisor.ConfigurationsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armadvisor.ConfigurationsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method ConfigurationsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armadvisor.ConfigurationsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armadvisor.ConfigurationsClientListBySubscriptionResponse])
}

// NewConfigurationsServerTransport creates a new instance of ConfigurationsServerTransport with the provided implementation.
// The returned ConfigurationsServerTransport instance is connected to an instance of armadvisor.ConfigurationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConfigurationsServerTransport(srv *ConfigurationsServer) *ConfigurationsServerTransport {
	return &ConfigurationsServerTransport{
		srv:                         srv,
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armadvisor.ConfigurationsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armadvisor.ConfigurationsClientListBySubscriptionResponse]](),
	}
}

// ConfigurationsServerTransport connects instances of armadvisor.ConfigurationsClient to instances of ConfigurationsServer.
// Don't use this type directly, use NewConfigurationsServerTransport instead.
type ConfigurationsServerTransport struct {
	srv                         *ConfigurationsServer
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armadvisor.ConfigurationsClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armadvisor.ConfigurationsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for ConfigurationsServerTransport.
func (c *ConfigurationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConfigurationsClient.CreateInResourceGroup":
		resp, err = c.dispatchCreateInResourceGroup(req)
	case "ConfigurationsClient.CreateInSubscription":
		resp, err = c.dispatchCreateInSubscription(req)
	case "ConfigurationsClient.NewListByResourceGroupPager":
		resp, err = c.dispatchNewListByResourceGroupPager(req)
	case "ConfigurationsClient.NewListBySubscriptionPager":
		resp, err = c.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConfigurationsServerTransport) dispatchCreateInResourceGroup(req *http.Request) (*http.Response, error) {
	if c.srv.CreateInResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateInResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroup>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Advisor/configurations/(?P<configurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armadvisor.ConfigData](req)
	if err != nil {
		return nil, err
	}
	configurationNameParam, err := parseWithCast(matches[regex.SubexpIndex("configurationName")], func(v string) (armadvisor.ConfigurationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armadvisor.ConfigurationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	resourceGroupParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroup")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateInResourceGroup(req.Context(), configurationNameParam, resourceGroupParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigData, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationsServerTransport) dispatchCreateInSubscription(req *http.Request) (*http.Response, error) {
	if c.srv.CreateInSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateInSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Advisor/configurations/(?P<configurationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armadvisor.ConfigData](req)
	if err != nil {
		return nil, err
	}
	configurationNameParam, err := parseWithCast(matches[regex.SubexpIndex("configurationName")], func(v string) (armadvisor.ConfigurationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armadvisor.ConfigurationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateInSubscription(req.Context(), configurationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigData, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := c.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroup>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Advisor/configurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroup")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByResourceGroupPager(resourceGroupParam, nil)
		newListByResourceGroupPager = &resp
		c.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		c.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := c.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Advisor/configurations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		c.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armadvisor.ConfigurationsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		c.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
