//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatashare

import "time"

// ADLSGen1FileDataSet - An ADLS Gen 1 file data set.
type ADLSGen1FileDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; ADLS Gen 1 file data set properties.
	Properties *ADLSGen1FileProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen1FileDataSet.
func (a *ADLSGen1FileDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen1FileProperties - Properties of the ADLS Gen1 file data set.
type ADLSGen1FileProperties struct {
	// REQUIRED; The ADLS account name.
	AccountName *string

	// REQUIRED; The file name in the ADLS account.
	FileName *string

	// REQUIRED; The folder path within the ADLS account.
	FolderPath *string

	// REQUIRED; Resource group of ADLS account.
	ResourceGroup *string

	// REQUIRED; Subscription id of ADLS account.
	SubscriptionID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// ADLSGen1FolderDataSet - An ADLS Gen 1 folder data set.
type ADLSGen1FolderDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; ADLS Gen 1 folder data set properties.
	Properties *ADLSGen1FolderProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen1FolderDataSet.
func (a *ADLSGen1FolderDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen1FolderProperties - Properties of the ADLS Gen1 folder data set.
type ADLSGen1FolderProperties struct {
	// REQUIRED; The ADLS account name.
	AccountName *string

	// REQUIRED; The folder path within the ADLS account.
	FolderPath *string

	// REQUIRED; Resource group of ADLS account.
	ResourceGroup *string

	// REQUIRED; Subscription id of ADLS account.
	SubscriptionID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// ADLSGen2FileDataSet - An ADLS Gen 2 file data set.
type ADLSGen2FileDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; ADLS Gen 2 file data set properties.
	Properties *ADLSGen2FileProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen2FileDataSet.
func (a *ADLSGen2FileDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FileDataSetMapping - An ADLS Gen2 file data set mapping.
type ADLSGen2FileDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; ADLS Gen2 file data set mapping properties.
	Properties *ADLSGen2FileDataSetMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type ADLSGen2FileDataSetMapping.
func (a *ADLSGen2FileDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FileDataSetMappingProperties - ADLS Gen 2 file data set mapping property bag.
type ADLSGen2FileDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; File path within the file system.
	FilePath *string

	// REQUIRED; File system to which the file belongs.
	FileSystem *string

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string

	// Type of output file
	OutputType *OutputType

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// ADLSGen2FileProperties - Properties of the ADLS Gen2 file data set.
type ADLSGen2FileProperties struct {
	// REQUIRED; File path within the file system.
	FilePath *string

	// REQUIRED; File system to which the file belongs.
	FileSystem *string

	// REQUIRED; Resource group of storage account
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// ADLSGen2FileSystemDataSet - An ADLS Gen 2 file system data set.
type ADLSGen2FileSystemDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; ADLS Gen 2 file system data set properties.
	Properties *ADLSGen2FileSystemProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen2FileSystemDataSet.
func (a *ADLSGen2FileSystemDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FileSystemDataSetMapping - An ADLS Gen2 file system data set mapping.
type ADLSGen2FileSystemDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; ADLS Gen2 file system data set mapping properties.
	Properties *ADLSGen2FileSystemDataSetMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type ADLSGen2FileSystemDataSetMapping.
func (a *ADLSGen2FileSystemDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FileSystemDataSetMappingProperties - ADLS Gen 2 file system data set mapping property bag.
type ADLSGen2FileSystemDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; The file system name.
	FileSystem *string

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// ADLSGen2FileSystemProperties - Properties of the ADLS Gen2 file system data set.
type ADLSGen2FileSystemProperties struct {
	// REQUIRED; The file system name.
	FileSystem *string

	// REQUIRED; Resource group of storage account
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// ADLSGen2FolderDataSet - An ADLS Gen 2 folder data set.
type ADLSGen2FolderDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; ADLS Gen 2 folder data set properties.
	Properties *ADLSGen2FolderProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen2FolderDataSet.
func (a *ADLSGen2FolderDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FolderDataSetMapping - An ADLS Gen2 folder data set mapping.
type ADLSGen2FolderDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; ADLS Gen2 folder data set mapping properties.
	Properties *ADLSGen2FolderDataSetMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type ADLSGen2FolderDataSetMapping.
func (a *ADLSGen2FolderDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FolderDataSetMappingProperties - ADLS Gen 2 folder data set mapping property bag.
type ADLSGen2FolderDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; File system to which the folder belongs.
	FileSystem *string

	// REQUIRED; Folder path within the file system.
	FolderPath *string

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// ADLSGen2FolderProperties - Properties of the ADLS Gen2 folder data set.
type ADLSGen2FolderProperties struct {
	// REQUIRED; File system to which the folder belongs.
	FileSystem *string

	// REQUIRED; Folder path within the file system.
	FolderPath *string

	// REQUIRED; Resource group of storage account
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// Account - An account data transfer object.
type Account struct {
	// REQUIRED; Identity Info on the Account
	Identity *Identity

	// Location of the azure resource.
	Location *string

	// Properties on the account
	Properties *AccountProperties

	// Tags on the azure resource.
	Tags map[string]*string

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// AccountList - List response for get Accounts.
type AccountList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*Account

	// The Url of next result page.
	NextLink *string
}

// AccountProperties - Account property bag.
type AccountProperties struct {
	// READ-ONLY; Time at which the account was created.
	CreatedAt *time.Time

	// READ-ONLY; Provisioning state of the Account
	ProvisioningState *ProvisioningState

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string

	// READ-ONLY; Name of the user who created the resource
	UserName *string
}

// AccountUpdateParameters - Update parameters for accounts
type AccountUpdateParameters struct {
	// Tags on the azure resource.
	Tags map[string]*string
}

// BlobContainerDataSet - An Azure storage blob container data set.
type BlobContainerDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; Blob container data set properties.
	Properties *BlobContainerProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type BlobContainerDataSet.
func (b *BlobContainerDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         b.ID,
		Kind:       b.Kind,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobContainerDataSetMapping - A Blob container data set mapping.
type BlobContainerDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; Blob container data set mapping properties.
	Properties *BlobContainerMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type BlobContainerDataSetMapping.
func (b *BlobContainerDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         b.ID,
		Kind:       b.Kind,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobContainerMappingProperties - Azure storage Blob container data set mapping property bag.
type BlobContainerMappingProperties struct {
	// REQUIRED; BLOB Container name.
	ContainerName *string

	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// BlobContainerProperties - Properties of the BLOB container data set.
type BlobContainerProperties struct {
	// REQUIRED; BLOB Container name.
	ContainerName *string

	// REQUIRED; Resource group of storage account
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// BlobDataSet - An Azure storage blob data set.
type BlobDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; Blob data set properties.
	Properties *BlobProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type BlobDataSet.
func (b *BlobDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         b.ID,
		Kind:       b.Kind,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobDataSetMapping - A Blob data set mapping.
type BlobDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; Blob data set mapping properties.
	Properties *BlobMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type BlobDataSetMapping.
func (b *BlobDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         b.ID,
		Kind:       b.Kind,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobFolderDataSet - An Azure storage blob folder data set.
type BlobFolderDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; Blob folder data set properties.
	Properties *BlobFolderProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type BlobFolderDataSet.
func (b *BlobFolderDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         b.ID,
		Kind:       b.Kind,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobFolderDataSetMapping - A Blob folder data set mapping.
type BlobFolderDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; Blob folder data set mapping properties.
	Properties *BlobFolderMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type BlobFolderDataSetMapping.
func (b *BlobFolderDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         b.ID,
		Kind:       b.Kind,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobFolderMappingProperties - Azure storage Blob folder data set mapping property bag.
type BlobFolderMappingProperties struct {
	// REQUIRED; Container that has the file path.
	ContainerName *string

	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; Prefix for blob folder
	Prefix *string

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// BlobFolderProperties - Properties of the blob folder data set.
type BlobFolderProperties struct {
	// REQUIRED; Container that has the file path.
	ContainerName *string

	// REQUIRED; Prefix for blob folder
	Prefix *string

	// REQUIRED; Resource group of storage account
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// BlobMappingProperties - Azure storage Blob data set mapping property bag.
type BlobMappingProperties struct {
	// REQUIRED; Container that has the file path.
	ContainerName *string

	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; File path within the source data set
	FilePath *string

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string

	// File output type
	OutputType *OutputType

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// BlobProperties - Properties of the blob data set.
type BlobProperties struct {
	// REQUIRED; Container that has the file path.
	ContainerName *string

	// REQUIRED; File path within the source data set
	FilePath *string

	// REQUIRED; Resource group of storage account
	ResourceGroup *string

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// ConsumerInvitation - A consumer Invitation data transfer object.
type ConsumerInvitation struct {
	// REQUIRED; Properties on the account
	Properties *ConsumerInvitationProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// ConsumerInvitationList - List response for get InvitationList
type ConsumerInvitationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ConsumerInvitation

	// The Url of next result page.
	NextLink *string
}

// ConsumerInvitationProperties - Properties of consumer invitation
type ConsumerInvitationProperties struct {
	// REQUIRED; Unique id of the invitation.
	InvitationID *string

	// READ-ONLY; Number of data sets in a share
	DataSetCount *int32

	// READ-ONLY; Description shared when the invitation was created
	Description *string

	// READ-ONLY; The expiration date for the share subscription created by accepting the invitation.
	ExpirationDate *time.Time

	// READ-ONLY; The status of the invitation.
	InvitationStatus *InvitationStatus

	// READ-ONLY; invitation location
	Location *string

	// READ-ONLY; Email of the provider who created the resource
	ProviderEmail *string

	// READ-ONLY; Name of the provider who created the resource
	ProviderName *string

	// READ-ONLY; Tenant name of the provider who created the resource
	ProviderTenantName *string

	// READ-ONLY; The time the recipient responded to the invitation.
	RespondedAt *time.Time

	// READ-ONLY; Gets the time at which the invitation was sent.
	SentAt *time.Time

	// READ-ONLY; Gets the source share Name.
	ShareName *string

	// READ-ONLY; Terms of use shared when the invitation was created
	TermsOfUse *string

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string

	// READ-ONLY; Name of the user who created the resource
	UserName *string
}

// ConsumerSourceDataSet - A consumer side dataSet data transfer object.
type ConsumerSourceDataSet struct {
	// source dataSet properties
	Properties *ConsumerSourceDataSetProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// ConsumerSourceDataSetList - A consumer side list of source dataSets
type ConsumerSourceDataSetList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ConsumerSourceDataSet

	// The Url of next result page.
	NextLink *string
}

// ConsumerSourceDataSetProperties - Properties of consumer source dataSet
type ConsumerSourceDataSetProperties struct {
	// READ-ONLY; DataSet Id
	DataSetID *string

	// READ-ONLY; Location of the data set.
	DataSetLocation *string

	// READ-ONLY; DataSet name
	DataSetName *string

	// READ-ONLY; DataSet path
	DataSetPath *string

	// READ-ONLY; Type of data set
	DataSetType *DataSetType
}

// DataSet - A DataSet data transfer object.
type DataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type DataSet.
func (d *DataSet) GetDataSet() *DataSet { return d }

// DataSetList - List response for get DataSets
type DataSetList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []DataSetClassification

	// The Url of next result page.
	NextLink *string
}

// DataSetMapping - A data set mapping data transfer object.
type DataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type DataSetMapping.
func (d *DataSetMapping) GetDataSetMapping() *DataSetMapping { return d }

// DataSetMappingList - List response for get DataSetMappings
type DataSetMappingList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []DataSetMappingClassification

	// The Url of next result page.
	NextLink *string
}

// DefaultDto - Base data transfer object implementation for default resources.
type DefaultDto struct {
	// Location of the azure resource.
	Location *string

	// Tags on the azure resource.
	Tags map[string]*string

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// DimensionProperties - properties for dimension
type DimensionProperties struct {
	// localized display name of the dimension to customer
	DisplayName *string

	// dimension name
	Name *string
}

// EmailRegistration - Dto for tenant domain registration
type EmailRegistration struct {
	// Activation code for the registration
	ActivationCode *string

	// READ-ONLY; Date of the activation expiration
	ActivationExpirationDate *time.Time

	// READ-ONLY; The email to register
	Email *string

	// READ-ONLY; Registration status
	RegistrationStatus *RegistrationStatus

	// READ-ONLY; The tenant to register
	TenantID *string
}

// Error - The data share error model.
type Error struct {
	// REQUIRED; The data share error body
	Error *ErrorInfo
}

// ErrorInfo - The data share error body model.
type ErrorInfo struct {
	// REQUIRED; Code of the error
	Code *string

	// REQUIRED; Message of the error
	Message *string

	// Nested details of the error model
	Details []*ErrorInfo

	// Target of the error
	Target *string
}

// Identity of resource
type Identity struct {
	// Identity Type
	Type *Type

	// READ-ONLY; service principal Id
	PrincipalID *string

	// READ-ONLY; Tenant Id
	TenantID *string
}

// Invitation - A Invitation data transfer object.
type Invitation struct {
	// Properties on the Invitation
	Properties *InvitationProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// InvitationList - List response for get InvitationList
type InvitationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*Invitation

	// The Url of next result page.
	NextLink *string
}

// InvitationProperties - Invitation property bag.
type InvitationProperties struct {
	// The expiration date for the invitation and share subscription.
	ExpirationDate *time.Time

	// The target Azure AD Id. Can't be combined with email.
	TargetActiveDirectoryID *string

	// The email the invitation is directed to.
	TargetEmail *string

	// The target user or application Id that invitation is being sent to. Must be specified along TargetActiveDirectoryId. This
	// enables sending invitations to specific users or applications in an AD tenant.
	TargetObjectID *string

	// READ-ONLY; unique invitation id
	InvitationID *string

	// READ-ONLY; The status of the invitation.
	InvitationStatus *InvitationStatus

	// READ-ONLY; The time the recipient responded to the invitation.
	RespondedAt *time.Time

	// READ-ONLY; Gets the time at which the invitation was sent.
	SentAt *time.Time

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string

	// READ-ONLY; Name of the user who created the resource
	UserName *string
}

// KustoClusterDataSet - A kusto cluster data set.
type KustoClusterDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; Kusto cluster data set properties.
	Properties *KustoClusterDataSetProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type KustoClusterDataSet.
func (k *KustoClusterDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         k.ID,
		Kind:       k.Kind,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KustoClusterDataSetMapping - A Kusto cluster data set mapping
type KustoClusterDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; Kusto cluster data set mapping properties.
	Properties *KustoClusterDataSetMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type KustoClusterDataSetMapping.
func (k *KustoClusterDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         k.ID,
		Kind:       k.Kind,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KustoClusterDataSetMappingProperties - Properties of the Kusto cluster data set mapping
type KustoClusterDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; Resource id of the sink kusto cluster.
	KustoClusterResourceID *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Location of the sink kusto cluster.
	Location *string

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// KustoClusterDataSetProperties - Properties of the kusto cluster data set.
type KustoClusterDataSetProperties struct {
	// REQUIRED; Resource id of the kusto cluster.
	KustoClusterResourceID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string

	// READ-ONLY; Location of the kusto cluster.
	Location *string

	// READ-ONLY; Provisioning state of the kusto cluster data set.
	ProvisioningState *ProvisioningState
}

// KustoDatabaseDataSet - A kusto database data set.
type KustoDatabaseDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; Kusto database data set properties.
	Properties *KustoDatabaseDataSetProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type KustoDatabaseDataSet.
func (k *KustoDatabaseDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         k.ID,
		Kind:       k.Kind,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KustoDatabaseDataSetMapping - A Kusto database data set mapping
type KustoDatabaseDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; Kusto database data set mapping properties.
	Properties *KustoDatabaseDataSetMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type KustoDatabaseDataSetMapping.
func (k *KustoDatabaseDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         k.ID,
		Kind:       k.Kind,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KustoDatabaseDataSetMappingProperties - Properties of the Kusto database data set mapping
type KustoDatabaseDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; Resource id of the sink kusto cluster.
	KustoClusterResourceID *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Location of the sink kusto cluster.
	Location *string

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// KustoDatabaseDataSetProperties - Properties of the kusto database data set.
type KustoDatabaseDataSetProperties struct {
	// REQUIRED; Resource id of the kusto database.
	KustoDatabaseResourceID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string

	// READ-ONLY; Location of the kusto cluster.
	Location *string

	// READ-ONLY; Provisioning state of the kusto database data set.
	ProvisioningState *ProvisioningState
}

// OperationList - List response for get operations.
type OperationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*OperationModel

	// The Url of next result page.
	NextLink *string
}

// OperationMetaLogSpecification - log specifications for operation api
type OperationMetaLogSpecification struct {
	// blob duration of the log
	BlobDuration *string

	// localized name of the log category
	DisplayName *string

	// name of the log category
	Name *string
}

// OperationMetaMetricSpecification - metric specifications for the operation
type OperationMetaMetricSpecification struct {
	// aggregation type of metric
	AggregationType *string

	// properties for dimension
	Dimensions []*DimensionProperties

	// description of the metric
	DisplayDescription *string

	// localized name of the metric
	DisplayName *string

	// enable regional mdm account
	EnableRegionalMdmAccount *string

	// fill gap with zero
	FillGapWithZero *bool

	// internal metric name
	InternalMetricName *string

	// name of the metric
	Name *string

	// dimension name use to replace resource id if specified
	ResourceIDDimensionNameOverride *string

	// supported aggregation types
	SupportedAggregationTypes []*string

	// supported time grain types
	SupportedTimeGrainTypes []*string

	// units for the metric
	Unit *string
}

// OperationMetaPropertyInfo - properties on meta info
type OperationMetaPropertyInfo struct {
	// meta service specification
	ServiceSpecification *OperationMetaServiceSpecification
}

// OperationMetaServiceSpecification - The operation meta service specification
type OperationMetaServiceSpecification struct {
	// log specifications for the operation
	LogSpecifications []*OperationMetaLogSpecification

	// metric specifications for the operation
	MetricSpecifications []*OperationMetaMetricSpecification
}

// OperationModel - The response model for get operations
type OperationModel struct {
	// Properties on the operation
	Display *OperationModelProperties

	// Operation name for display purposes
	Name *string

	// origin of the operation
	Origin *string

	// properties for the operation meta info
	Properties *OperationMetaPropertyInfo
}

// OperationModelProperties - Properties on operations
type OperationModelProperties struct {
	// Description of the operation for display purposes
	Description *string

	// Name of the operation for display purposes
	Operation *string

	// Name of the provider for display purposes
	Provider *string

	// Name of the resource type for display purposes
	Resource *string
}

// OperationResponse - Response for long running operation
type OperationResponse struct {
	// REQUIRED; Operation state of the long running operation.
	Status *Status

	// start time
	EndTime *time.Time

	// The error property when status is failed.
	Error *ErrorInfo

	// start time
	StartTime *time.Time
}

// ProviderShareSubscription - A provider side share subscription data transfer object.
type ProviderShareSubscription struct {
	// properties of providerShareSubscription
	Properties *ProviderShareSubscriptionProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// ProviderShareSubscriptionList - List response for get ShareSubscription.
type ProviderShareSubscriptionList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ProviderShareSubscription

	// The Url of next result page.
	NextLink *string
}

// ProviderShareSubscriptionProperties - Provider share subscription properties
type ProviderShareSubscriptionProperties struct {
	// Expiration date of the share subscription in UTC format
	ExpirationDate *time.Time

	// READ-ONLY; Email of the consumer who created the share subscription
	ConsumerEmail *string

	// READ-ONLY; Name of the consumer who created the share subscription
	ConsumerName *string

	// READ-ONLY; Tenant name of the consumer who created the share subscription
	ConsumerTenantName *string

	// READ-ONLY; created at
	CreatedAt *time.Time

	// READ-ONLY; Email of the provider who created the share
	ProviderEmail *string

	// READ-ONLY; Name of the provider who created the share
	ProviderName *string

	// READ-ONLY; share Subscription Object Id
	ShareSubscriptionObjectID *string

	// READ-ONLY; Gets the status of share subscription
	ShareSubscriptionStatus *ShareSubscriptionStatus

	// READ-ONLY; Shared at
	SharedAt *time.Time
}

// ProxyDto - Base data transfer object implementation for proxy resources.
type ProxyDto struct {
	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// SQLDBTableDataSet - A SQL DB table data set.
type SQLDBTableDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// SQL DB table data set properties.
	Properties *SQLDBTableProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type SQLDBTableDataSet.
func (s *SQLDBTableDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SQLDBTableDataSetMapping - A SQL DB Table data set mapping.
type SQLDBTableDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; Sql DB data set mapping properties.
	Properties *SQLDBTableDataSetMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type SQLDBTableDataSetMapping.
func (s *SQLDBTableDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SQLDBTableDataSetMappingProperties - Properties of the SQL DB table data set mapping.
type SQLDBTableDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; DatabaseName name of the sink data set
	DatabaseName *string

	// REQUIRED; Resource id of SQL server
	SQLServerResourceID *string

	// REQUIRED; Schema of the table. Default value is dbo.
	SchemaName *string

	// REQUIRED; SQL DB table name.
	TableName *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// SQLDBTableProperties - Properties of the SQL DB table data set.
type SQLDBTableProperties struct {
	// REQUIRED; Database name of the source data set
	DatabaseName *string

	// REQUIRED; Resource id of SQL server
	SQLServerResourceID *string

	// REQUIRED; Schema of the table. Default value is dbo.
	SchemaName *string

	// REQUIRED; SQL DB table name.
	TableName *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// SQLDWTableDataSet - A SQL DW table data set.
type SQLDWTableDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// SQL DW table data set properties.
	Properties *SQLDWTableProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type SQLDWTableDataSet.
func (s *SQLDWTableDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SQLDWTableDataSetMapping - A SQL DW Table data set mapping.
type SQLDWTableDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; Sql DW data set mapping properties.
	Properties *SQLDWTableDataSetMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type SQLDWTableDataSetMapping.
func (s *SQLDWTableDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SQLDWTableDataSetMappingProperties - Properties of the SQL DW table data set mapping.
type SQLDWTableDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; DataWarehouse name of the source data set
	DataWarehouseName *string

	// REQUIRED; Resource id of SQL server
	SQLServerResourceID *string

	// REQUIRED; Schema of the table. Default value is dbo.
	SchemaName *string

	// REQUIRED; SQL DW table name.
	TableName *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// SQLDWTableProperties - Properties of the SQL DW table data set.
type SQLDWTableProperties struct {
	// REQUIRED; DataWarehouse name of the source data set
	DataWarehouseName *string

	// REQUIRED; Resource id of SQL server
	SQLServerResourceID *string

	// REQUIRED; Schema of the table. Default value is dbo.
	SchemaName *string

	// REQUIRED; SQL DW table name.
	TableName *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// ScheduledSourceShareSynchronizationSettingProperties - A Scheduled source synchronization setting data transfer object.
type ScheduledSourceShareSynchronizationSettingProperties struct {
	// Recurrence Interval
	RecurrenceInterval *RecurrenceInterval

	// Synchronization time
	SynchronizationTime *time.Time
}

// ScheduledSourceSynchronizationSetting - A type of synchronization setting based on schedule
type ScheduledSourceSynchronizationSetting struct {
	// REQUIRED; Kind of synchronization setting on share.
	Kind *SourceShareSynchronizationSettingKind

	// Properties of scheduled synchronization
	Properties *ScheduledSourceShareSynchronizationSettingProperties
}

// GetSourceShareSynchronizationSetting implements the SourceShareSynchronizationSettingClassification interface for type
// ScheduledSourceSynchronizationSetting.
func (s *ScheduledSourceSynchronizationSetting) GetSourceShareSynchronizationSetting() *SourceShareSynchronizationSetting {
	return &SourceShareSynchronizationSetting{
		Kind: s.Kind,
	}
}

// ScheduledSynchronizationSetting - A type of synchronization setting based on schedule
type ScheduledSynchronizationSetting struct {
	// REQUIRED; Kind of synchronization setting.
	Kind *SynchronizationSettingKind

	// REQUIRED; Properties of scheduled synchronization
	Properties *ScheduledSynchronizationSettingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetSynchronizationSetting implements the SynchronizationSettingClassification interface for type ScheduledSynchronizationSetting.
func (s *ScheduledSynchronizationSetting) GetSynchronizationSetting() *SynchronizationSetting {
	return &SynchronizationSetting{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// ScheduledSynchronizationSettingProperties - A Scheduled synchronization setting data transfer object.
type ScheduledSynchronizationSettingProperties struct {
	// REQUIRED; Recurrence Interval
	RecurrenceInterval *RecurrenceInterval

	// REQUIRED; Synchronization time
	SynchronizationTime *time.Time

	// READ-ONLY; Time at which the synchronization setting was created.
	CreatedAt *time.Time

	// READ-ONLY; Gets or sets the provisioning state
	ProvisioningState *ProvisioningState

	// READ-ONLY; Name of the user who created the synchronization setting.
	UserName *string
}

// ScheduledTrigger - A type of trigger based on schedule
type ScheduledTrigger struct {
	// REQUIRED; Kind of synchronization on trigger.
	Kind *TriggerKind

	// REQUIRED; Properties of scheduled synchronization
	Properties *ScheduledTriggerProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetTrigger implements the TriggerClassification interface for type ScheduledTrigger.
func (s *ScheduledTrigger) GetTrigger() *Trigger {
	return &Trigger{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// ScheduledTriggerProperties - A Scheduled trigger data transfer object.
type ScheduledTriggerProperties struct {
	// REQUIRED; Recurrence Interval
	RecurrenceInterval *RecurrenceInterval

	// REQUIRED; Synchronization time
	SynchronizationTime *time.Time

	// Synchronization mode
	SynchronizationMode *SynchronizationMode

	// READ-ONLY; Time at which the trigger was created.
	CreatedAt *time.Time

	// READ-ONLY; Gets the provisioning state
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets the trigger state
	TriggerStatus *TriggerStatus

	// READ-ONLY; Name of the user who created the trigger.
	UserName *string
}

// Share - A share data transfer object.
type Share struct {
	// Properties on the share
	Properties *ShareProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// ShareList - List response for get Shares.
type ShareList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*Share

	// The Url of next result page.
	NextLink *string
}

// ShareProperties - Share property bag.
type ShareProperties struct {
	// Share description.
	Description *string

	// Share kind.
	ShareKind *ShareKind

	// Share terms.
	Terms *string

	// READ-ONLY; Time at which the share was created.
	CreatedAt *time.Time

	// READ-ONLY; Gets or sets the provisioning state
	ProvisioningState *ProvisioningState

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string

	// READ-ONLY; Name of the user who created the resource
	UserName *string
}

// ShareSubscription - A share subscription data transfer object.
type ShareSubscription struct {
	// REQUIRED; Properties on the share subscription
	Properties *ShareSubscriptionProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// ShareSubscriptionList - List response for get ShareSubscription.
type ShareSubscriptionList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ShareSubscription

	// The Url of next result page.
	NextLink *string
}

// ShareSubscriptionProperties - Share subscription property bag.
type ShareSubscriptionProperties struct {
	// REQUIRED; The invitation id.
	InvitationID *string

	// REQUIRED; Source share location.
	SourceShareLocation *string

	// The expiration date of the share subscription.
	ExpirationDate *time.Time

	// READ-ONLY; Time at which the share subscription was created.
	CreatedAt *time.Time

	// READ-ONLY; Email of the provider who created the resource
	ProviderEmail *string

	// READ-ONLY; Name of the provider who created the resource
	ProviderName *string

	// READ-ONLY; Tenant name of the provider who created the resource
	ProviderTenantName *string

	// READ-ONLY; Provisioning state of the share subscription
	ProvisioningState *ProvisioningState

	// READ-ONLY; Description of share
	ShareDescription *string

	// READ-ONLY; Kind of share
	ShareKind *ShareKind

	// READ-ONLY; Name of the share
	ShareName *string

	// READ-ONLY; Gets the current status of share subscription.
	ShareSubscriptionStatus *ShareSubscriptionStatus

	// READ-ONLY; Terms of a share
	ShareTerms *string

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string

	// READ-ONLY; Name of the user who created the resource
	UserName *string
}

// ShareSubscriptionSynchronization - A ShareSubscriptionSynchronization data transfer object.
type ShareSubscriptionSynchronization struct {
	// REQUIRED; Synchronization id
	SynchronizationID *string

	// READ-ONLY; Synchronization duration
	DurationMs *int32

	// READ-ONLY; End time of synchronization
	EndTime *time.Time

	// READ-ONLY; message of Synchronization
	Message *string

	// READ-ONLY; start time of synchronization
	StartTime *time.Time

	// READ-ONLY; Raw Status
	Status *string

	// READ-ONLY; Synchronization Mode
	SynchronizationMode *SynchronizationMode
}

// ShareSubscriptionSynchronizationList - A consumer side list of share subscription synchronizations
type ShareSubscriptionSynchronizationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ShareSubscriptionSynchronization

	// The Url of next result page.
	NextLink *string
}

// ShareSynchronization - A ShareSynchronization data transfer object.
type ShareSynchronization struct {
	// Email of the user who created the synchronization
	ConsumerEmail *string

	// Name of the user who created the synchronization
	ConsumerName *string

	// Tenant name of the consumer who created the synchronization
	ConsumerTenantName *string

	// synchronization duration
	DurationMs *int32

	// End time of synchronization
	EndTime *time.Time

	// message of synchronization
	Message *string

	// start time of synchronization
	StartTime *time.Time

	// Raw Status
	Status *string

	// Synchronization id
	SynchronizationID *string

	// READ-ONLY; Synchronization mode
	SynchronizationMode *SynchronizationMode
}

// ShareSynchronizationList - List response for get ShareSynchronization.
type ShareSynchronizationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ShareSynchronization

	// The Url of next result page.
	NextLink *string
}

// SourceShareSynchronizationSetting - A view of synchronization setting added by the provider
type SourceShareSynchronizationSetting struct {
	// REQUIRED; Kind of synchronization setting on share.
	Kind *SourceShareSynchronizationSettingKind
}

// GetSourceShareSynchronizationSetting implements the SourceShareSynchronizationSettingClassification interface for type
// SourceShareSynchronizationSetting.
func (s *SourceShareSynchronizationSetting) GetSourceShareSynchronizationSetting() *SourceShareSynchronizationSetting {
	return s
}

// SourceShareSynchronizationSettingList - List response for get source share Synchronization settings
type SourceShareSynchronizationSettingList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []SourceShareSynchronizationSettingClassification

	// The Url of next result page.
	NextLink *string
}

// SynapseWorkspaceSQLPoolTableDataSet - A Synapse Workspace Sql Pool Table data set.
type SynapseWorkspaceSQLPoolTableDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind

	// REQUIRED; Synapse Workspace Sql Pool Table data set properties.
	Properties *SynapseWorkspaceSQLPoolTableDataSetProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSet implements the DataSetClassification interface for type SynapseWorkspaceSQLPoolTableDataSet.
func (s *SynapseWorkspaceSQLPoolTableDataSet) GetDataSet() *DataSet {
	return &DataSet{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SynapseWorkspaceSQLPoolTableDataSetMapping - A Synapse Workspace Sql Pool Table data set mapping
type SynapseWorkspaceSQLPoolTableDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind

	// REQUIRED; A Synapse Workspace Sql Pool Table data set mapping properties.
	Properties *SynapseWorkspaceSQLPoolTableDataSetMappingProperties

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type SynapseWorkspaceSQLPoolTableDataSetMapping.
func (s *SynapseWorkspaceSQLPoolTableDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SynapseWorkspaceSQLPoolTableDataSetMappingProperties - Properties of the Synapse Workspace SQL Pool Table data set mapping
type SynapseWorkspaceSQLPoolTableDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string

	// REQUIRED; Resource id of the Synapse Workspace SQL Pool Table
	SynapseWorkspaceSQLPoolTableResourceID *string

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState
}

// SynapseWorkspaceSQLPoolTableDataSetProperties - Properties of the Synapse Workspace SQL Pool Table data set.
type SynapseWorkspaceSQLPoolTableDataSetProperties struct {
	// REQUIRED; Resource id of the Synapse Workspace SQL Pool Table
	SynapseWorkspaceSQLPoolTableResourceID *string

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string
}

// SynchronizationDetails - Synchronization details at data set level
type SynchronizationDetails struct {
	// READ-ONLY; Id of data set
	DataSetID *string

	// READ-ONLY; Type of the data set
	DataSetType *DataSetType

	// READ-ONLY; Duration of data set level copy
	DurationMs *int32

	// READ-ONLY; End time of data set level copy
	EndTime *time.Time

	// READ-ONLY; The number of files read from the source data set
	FilesRead *int64

	// READ-ONLY; The number of files written into the sink data set
	FilesWritten *int64

	// READ-ONLY; Error message if any
	Message *string

	// READ-ONLY; Name of the data set
	Name *string

	// READ-ONLY; The number of files copied into the sink data set
	RowsCopied *int64

	// READ-ONLY; The number of rows read from the source data set.
	RowsRead *int64

	// READ-ONLY; The size of the data read from the source data set in bytes
	SizeRead *int64

	// READ-ONLY; The size of the data written into the sink data set in bytes
	SizeWritten *int64

	// READ-ONLY; Start time of data set level copy
	StartTime *time.Time

	// READ-ONLY; Raw Status
	Status *string

	// READ-ONLY; The vCore units consumed for the data set synchronization
	VCore *int64
}

// SynchronizationDetailsList - details of synchronization
type SynchronizationDetailsList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*SynchronizationDetails

	// The Url of next result page.
	NextLink *string
}

// SynchronizationSetting - A Synchronization Setting data transfer object.
type SynchronizationSetting struct {
	// REQUIRED; Kind of synchronization setting.
	Kind *SynchronizationSettingKind

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetSynchronizationSetting implements the SynchronizationSettingClassification interface for type SynchronizationSetting.
func (s *SynchronizationSetting) GetSynchronizationSetting() *SynchronizationSetting { return s }

// SynchronizationSettingList - List response for get Synchronization settings
type SynchronizationSettingList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []SynchronizationSettingClassification

	// The Url of next result page.
	NextLink *string
}

// Synchronize - Payload for the synchronizing the data.
type Synchronize struct {
	// Mode of synchronization used in triggers and snapshot sync. Incremental by default
	SynchronizationMode *SynchronizationMode
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *LastModifiedByType
}

// Trigger - A Trigger data transfer object.
type Trigger struct {
	// REQUIRED; Kind of synchronization on trigger.
	Kind *TriggerKind

	// READ-ONLY; The resource id of the azure resource
	ID *string

	// READ-ONLY; Name of the azure resource
	Name *string

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData

	// READ-ONLY; Type of the azure resource
	Type *string
}

// GetTrigger implements the TriggerClassification interface for type Trigger.
func (t *Trigger) GetTrigger() *Trigger { return t }

// TriggerList - List response for get triggers
type TriggerList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []TriggerClassification

	// The Url of next result page.
	NextLink *string
}
