//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
	"net/http"
	"net/url"
	"regexp"
)

// SharedKeysServer is a fake server for instances of the armoperationalinsights.SharedKeysClient type.
type SharedKeysServer struct {
	// GetSharedKeys is the fake for method SharedKeysClient.GetSharedKeys
	// HTTP status codes to indicate success: http.StatusOK
	GetSharedKeys func(ctx context.Context, resourceGroupName string, workspaceName string, options *armoperationalinsights.SharedKeysClientGetSharedKeysOptions) (resp azfake.Responder[armoperationalinsights.SharedKeysClientGetSharedKeysResponse], errResp azfake.ErrorResponder)

	// Regenerate is the fake for method SharedKeysClient.Regenerate
	// HTTP status codes to indicate success: http.StatusOK
	Regenerate func(ctx context.Context, resourceGroupName string, workspaceName string, options *armoperationalinsights.SharedKeysClientRegenerateOptions) (resp azfake.Responder[armoperationalinsights.SharedKeysClientRegenerateResponse], errResp azfake.ErrorResponder)
}

// NewSharedKeysServerTransport creates a new instance of SharedKeysServerTransport with the provided implementation.
// The returned SharedKeysServerTransport instance is connected to an instance of armoperationalinsights.SharedKeysClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSharedKeysServerTransport(srv *SharedKeysServer) *SharedKeysServerTransport {
	return &SharedKeysServerTransport{srv: srv}
}

// SharedKeysServerTransport connects instances of armoperationalinsights.SharedKeysClient to instances of SharedKeysServer.
// Don't use this type directly, use NewSharedKeysServerTransport instead.
type SharedKeysServerTransport struct {
	srv *SharedKeysServer
}

// Do implements the policy.Transporter interface for SharedKeysServerTransport.
func (s *SharedKeysServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SharedKeysClient.GetSharedKeys":
		resp, err = s.dispatchGetSharedKeys(req)
	case "SharedKeysClient.Regenerate":
		resp, err = s.dispatchRegenerate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SharedKeysServerTransport) dispatchGetSharedKeys(req *http.Request) (*http.Response, error) {
	if s.srv.GetSharedKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSharedKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sharedKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSharedKeys(req.Context(), resourceGroupNameParam, workspaceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SharedKeys, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SharedKeysServerTransport) dispatchRegenerate(req *http.Request) (*http.Response, error) {
	if s.srv.Regenerate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Regenerate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateSharedKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Regenerate(req.Context(), resourceGroupNameParam, workspaceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SharedKeys, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
