//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/paloaltonetworksngfw/armpanngfw"
	"net/http"
	"net/url"
	"regexp"
)

// FirewallStatusServer is a fake server for instances of the armpanngfw.FirewallStatusClient type.
type FirewallStatusServer struct {
	// Get is the fake for method FirewallStatusClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, firewallName string, options *armpanngfw.FirewallStatusClientGetOptions) (resp azfake.Responder[armpanngfw.FirewallStatusClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByFirewallsPager is the fake for method FirewallStatusClient.NewListByFirewallsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByFirewallsPager func(resourceGroupName string, firewallName string, options *armpanngfw.FirewallStatusClientListByFirewallsOptions) (resp azfake.PagerResponder[armpanngfw.FirewallStatusClientListByFirewallsResponse])
}

// NewFirewallStatusServerTransport creates a new instance of FirewallStatusServerTransport with the provided implementation.
// The returned FirewallStatusServerTransport instance is connected to an instance of armpanngfw.FirewallStatusClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFirewallStatusServerTransport(srv *FirewallStatusServer) *FirewallStatusServerTransport {
	return &FirewallStatusServerTransport{
		srv:                     srv,
		newListByFirewallsPager: newTracker[azfake.PagerResponder[armpanngfw.FirewallStatusClientListByFirewallsResponse]](),
	}
}

// FirewallStatusServerTransport connects instances of armpanngfw.FirewallStatusClient to instances of FirewallStatusServer.
// Don't use this type directly, use NewFirewallStatusServerTransport instead.
type FirewallStatusServerTransport struct {
	srv                     *FirewallStatusServer
	newListByFirewallsPager *tracker[azfake.PagerResponder[armpanngfw.FirewallStatusClientListByFirewallsResponse]]
}

// Do implements the policy.Transporter interface for FirewallStatusServerTransport.
func (f *FirewallStatusServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FirewallStatusClient.Get":
		resp, err = f.dispatchGet(req)
	case "FirewallStatusClient.NewListByFirewallsPager":
		resp, err = f.dispatchNewListByFirewallsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FirewallStatusServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if f.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/firewalls/(?P<firewallName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/statuses/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	firewallNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("firewallName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Get(req.Context(), resourceGroupNameParam, firewallNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FirewallStatusResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FirewallStatusServerTransport) dispatchNewListByFirewallsPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListByFirewallsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByFirewallsPager not implemented")}
	}
	newListByFirewallsPager := f.newListByFirewallsPager.get(req)
	if newListByFirewallsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/PaloAltoNetworks\.Cloudngfw/firewalls/(?P<firewallName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/statuses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		firewallNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("firewallName")])
		if err != nil {
			return nil, err
		}
		resp := f.srv.NewListByFirewallsPager(resourceGroupNameParam, firewallNameParam, nil)
		newListByFirewallsPager = &resp
		f.newListByFirewallsPager.add(req, newListByFirewallsPager)
		server.PagerResponderInjectNextLinks(newListByFirewallsPager, req, func(page *armpanngfw.FirewallStatusClientListByFirewallsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByFirewallsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListByFirewallsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByFirewallsPager) {
		f.newListByFirewallsPager.remove(req)
	}
	return resp, nil
}
