//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// PolicyMetadataServer is a fake server for instances of the armpolicyinsights.PolicyMetadataClient type.
type PolicyMetadataServer struct {
	// GetResource is the fake for method PolicyMetadataClient.GetResource
	// HTTP status codes to indicate success: http.StatusOK
	GetResource func(ctx context.Context, resourceName string, options *armpolicyinsights.PolicyMetadataClientGetResourceOptions) (resp azfake.Responder[armpolicyinsights.PolicyMetadataClientGetResourceResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method PolicyMetadataClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.PolicyMetadataClientListOptions) (resp azfake.PagerResponder[armpolicyinsights.PolicyMetadataClientListResponse])
}

// NewPolicyMetadataServerTransport creates a new instance of PolicyMetadataServerTransport with the provided implementation.
// The returned PolicyMetadataServerTransport instance is connected to an instance of armpolicyinsights.PolicyMetadataClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPolicyMetadataServerTransport(srv *PolicyMetadataServer) *PolicyMetadataServerTransport {
	return &PolicyMetadataServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armpolicyinsights.PolicyMetadataClientListResponse]](),
	}
}

// PolicyMetadataServerTransport connects instances of armpolicyinsights.PolicyMetadataClient to instances of PolicyMetadataServer.
// Don't use this type directly, use NewPolicyMetadataServerTransport instead.
type PolicyMetadataServerTransport struct {
	srv          *PolicyMetadataServer
	newListPager *tracker[azfake.PagerResponder[armpolicyinsights.PolicyMetadataClientListResponse]]
}

// Do implements the policy.Transporter interface for PolicyMetadataServerTransport.
func (p *PolicyMetadataServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PolicyMetadataClient.GetResource":
		resp, err = p.dispatchGetResource(req)
	case "PolicyMetadataClient.NewListPager":
		resp, err = p.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PolicyMetadataServerTransport) dispatchGetResource(req *http.Request) (*http.Response, error) {
	if p.srv.GetResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetResource not implemented")}
	}
	const regexStr = `/providers/Microsoft\.PolicyInsights/policyMetadata/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetResource(req.Context(), resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PolicyMetadata, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyMetadataServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := p.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top: topParam,
			}
		}
		resp := p.srv.NewListPager(queryOptions, nil)
		newListPager = &resp
		p.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpolicyinsights.PolicyMetadataClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		p.newListPager.remove(req)
	}
	return resp, nil
}
