//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// IotSecuritySolutionsAnalyticsRecommendationClient contains the methods for the IotSecuritySolutionsAnalyticsRecommendation group.
// Don't use this type directly, use NewIotSecuritySolutionsAnalyticsRecommendationClient() instead.
type IotSecuritySolutionsAnalyticsRecommendationClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewIotSecuritySolutionsAnalyticsRecommendationClient creates a new instance of IotSecuritySolutionsAnalyticsRecommendationClient with the specified values.
//   - subscriptionID - Azure subscription ID
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewIotSecuritySolutionsAnalyticsRecommendationClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*IotSecuritySolutionsAnalyticsRecommendationClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &IotSecuritySolutionsAnalyticsRecommendationClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Use this method to get the aggregated security analytics recommendation of yours IoT Security solution. This aggregation
// is performed by recommendation name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2019-08-01
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - solutionName - The name of the IoT Security solution.
//   - aggregatedRecommendationName - Name of the recommendation aggregated for this query.
//   - options - IotSecuritySolutionsAnalyticsRecommendationClientGetOptions contains the optional parameters for the IotSecuritySolutionsAnalyticsRecommendationClient.Get
//     method.
func (client *IotSecuritySolutionsAnalyticsRecommendationClient) Get(ctx context.Context, resourceGroupName string, solutionName string, aggregatedRecommendationName string, options *IotSecuritySolutionsAnalyticsRecommendationClientGetOptions) (IotSecuritySolutionsAnalyticsRecommendationClientGetResponse, error) {
	var err error
	const operationName = "IotSecuritySolutionsAnalyticsRecommendationClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, solutionName, aggregatedRecommendationName, options)
	if err != nil {
		return IotSecuritySolutionsAnalyticsRecommendationClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return IotSecuritySolutionsAnalyticsRecommendationClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return IotSecuritySolutionsAnalyticsRecommendationClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *IotSecuritySolutionsAnalyticsRecommendationClient) getCreateRequest(ctx context.Context, resourceGroupName string, solutionName string, aggregatedRecommendationName string, options *IotSecuritySolutionsAnalyticsRecommendationClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/iotSecuritySolutions/{solutionName}/analyticsModels/default/aggregatedRecommendations/{aggregatedRecommendationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if solutionName == "" {
		return nil, errors.New("parameter solutionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{solutionName}", url.PathEscape(solutionName))
	if aggregatedRecommendationName == "" {
		return nil, errors.New("parameter aggregatedRecommendationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{aggregatedRecommendationName}", url.PathEscape(aggregatedRecommendationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-08-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *IotSecuritySolutionsAnalyticsRecommendationClient) getHandleResponse(resp *http.Response) (IotSecuritySolutionsAnalyticsRecommendationClientGetResponse, error) {
	result := IotSecuritySolutionsAnalyticsRecommendationClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IoTSecurityAggregatedRecommendation); err != nil {
		return IotSecuritySolutionsAnalyticsRecommendationClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Use this method to get the list of aggregated security analytics recommendations of yours IoT Security solution.
//
// Generated from API version 2019-08-01
//   - resourceGroupName - The name of the resource group within the user's subscription. The name is case insensitive.
//   - solutionName - The name of the IoT Security solution.
//   - options - IotSecuritySolutionsAnalyticsRecommendationClientListOptions contains the optional parameters for the IotSecuritySolutionsAnalyticsRecommendationClient.NewListPager
//     method.
func (client *IotSecuritySolutionsAnalyticsRecommendationClient) NewListPager(resourceGroupName string, solutionName string, options *IotSecuritySolutionsAnalyticsRecommendationClientListOptions) *runtime.Pager[IotSecuritySolutionsAnalyticsRecommendationClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[IotSecuritySolutionsAnalyticsRecommendationClientListResponse]{
		More: func(page IotSecuritySolutionsAnalyticsRecommendationClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *IotSecuritySolutionsAnalyticsRecommendationClientListResponse) (IotSecuritySolutionsAnalyticsRecommendationClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "IotSecuritySolutionsAnalyticsRecommendationClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, solutionName, options)
			}, nil)
			if err != nil {
				return IotSecuritySolutionsAnalyticsRecommendationClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *IotSecuritySolutionsAnalyticsRecommendationClient) listCreateRequest(ctx context.Context, resourceGroupName string, solutionName string, options *IotSecuritySolutionsAnalyticsRecommendationClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/iotSecuritySolutions/{solutionName}/analyticsModels/default/aggregatedRecommendations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if solutionName == "" {
		return nil, errors.New("parameter solutionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{solutionName}", url.PathEscape(solutionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-08-01")
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *IotSecuritySolutionsAnalyticsRecommendationClient) listHandleResponse(resp *http.Response) (IotSecuritySolutionsAnalyticsRecommendationClientListResponse, error) {
	result := IotSecuritySolutionsAnalyticsRecommendationClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IoTSecurityAggregatedRecommendationList); err != nil {
		return IotSecuritySolutionsAnalyticsRecommendationClientListResponse{}, err
	}
	return result, nil
}
