/*
 * Copyright 2021-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.events.api;

import org.apiguardian.api.API;

import java.util.function.Consumer;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * Interface for objects that support appending child {@linkplain Element elements}.
 *
 * @param <T> parent element type
 * @since 0.1.0
 */
@API(status = EXPERIMENTAL, since = "0.1.0")
public interface Appendable<T extends Element<T>> {

	/**
	 * Append the child element created by the supplied {@linkplain Factory factory}.
	 *
	 * @param creator child element factory
	 * @param <C>     child element type
	 * @return self reference to allow method chaining
	 */
	default <C extends ChildElement<T, ? super C>> Appendable<T> append(Factory<C> creator) {
		return append(creator, __ -> {
		});
	}

	/**
	 * Append the child element created by the supplied {@linkplain Factory factory} configured by the supplied {@linkplain Consumer consumer}.
	 *
	 * @param creator    child element factory
	 * @param configurer child element configurer
	 * @param <C>        child element type
	 * @return self reference to allow method chaining
	 */
	<C extends ChildElement<T, ? super C>> Appendable<T> append(Factory<C> creator, Consumer<? super C> configurer);

}
