% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installConda.R
\name{installConda}
\alias{installConda}
\title{Install (Mini)conda}
\usage{
installConda(installed = TRUE)
}
\arguments{
\item{installed}{Logical scalar indicating whether \pkg{basilisk} is already installed.
Should only be set to \code{FALSE} in \pkg{basilisk} \code{configure} scripts.}
}
\value{
A conda instance is created at the location specified by \code{\link{getCondaDir}}.
Nothing is performed if a complete instance already exists at that location.
A logical scalar is returned indicating whether a new instance was created.
}
\description{
Install conda - specifically Miniconda, though historically we used Anaconda - to an appropriate destination path,
skipping the installation if said path already exists.
}
\details{
This function was originally created from code in \url{https://github.com/hafen/rminiconda},
also borrowing code from \pkg{reticulate}'s \code{install_miniconda} for correct Windows installation.
It downloads and runs a Miniconda installer to create a dedicated Conda instance that is managed by \pkg{basilisk},
separate from other instances that might be available on the system.

The installer itself is cached to avoid re-downloading it when, e.g., re-installing \pkg{basilisk} across separate R sessions.
Users can obtain/delete the cached installer by looking at the contents of the parent directory of \code{\link{getExternalDir}}.
This caching behavior is disabled for system installations (see \code{\link{useSystemDir}}), which touch nothing except the system directories;
in such cases, only repeated installation attempts in the same R session will re-use the same installer.

Currently, we use version 4.12.0 of the Miniconda3 installer, which also comes with Python 3.9.
Users can change this by setting the \code{BASILISK_MINICONDA_VERSION} environment variable, e.g., to \code{"py38_4.11.0"}.
Any change should be done with a great deal of caution, typically due to some system-specific problem with a particular Miniconda version.
If it must be done, users should try to stick to the same Python version.
}
\section{Destruction of old instances}{

Whenever \code{installConda} is re-run and \code{BASILISK_USE_SYSTEM_DIR} is not set, 
any old conda instances and their associated \pkg{basilisk} environments are deleted from the external installation directory.
This avoids duplication of large conda instances after their obselescence.
Client packages are expected to recreate their environments in the latest conda instance.

Users can disable this destruction by setting the \code{BASILISK_NO_DESTROY} environment variable to \code{"1"}.
This may be necessary on rare occasions when running multiple R instances on the same Bioconductor release.
Note that setting this variable is not required for R instances using different Bioconductor releases;
the destruction process is smart enough to only remove conda instances generated from the same release.
}

\section{Skipping the fallback R}{

When \code{BASILISK_USE_SYSTEM_DIR} is set, \code{installConda} will automatically create a conda environment with its own copy of R.
This is used as the \dQuote{last resort fallback} for running \pkg{reticulate} code in the presence of shared library incompatibilities with the main R installation.
If users know that no incompatibilities exist in their application, they can set the \code{BASILISK_NO_FALLBACK_R} variable to \code{"1"}.
This will instruct \code{installConda} to skip the creation of the fallback environment, saving some time and disk space.
}

\examples{
# We can't actually run installConda() here, as it 
# either relies on basilisk already being installed or
# it has a hard-coded path to the basilisk system dir.
print("dummy test to pass BiocCheck")

}
\author{
Aaron Lun
}
