% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{duration-rounding}
\alias{duration-rounding}
\alias{duration_floor}
\alias{duration_ceiling}
\alias{duration_round}
\title{Duration rounding}
\usage{
duration_floor(x, precision, ..., n = 1L)

duration_ceiling(x, precision, ..., n = 1L)

duration_round(x, precision, ..., n = 1L)
}
\arguments{
\item{x}{\verb{[clock_duration]}

A duration.}

\item{precision}{\verb{[character(1)]}

A precision. One of:
\itemize{
\item \code{"year"}
\item \code{"quarter"}
\item \code{"month"}
\item \code{"week"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A positive integer specifying the multiple of \code{precision} to use.}
}
\value{
\code{x} rounded to the \code{precision}.
}
\description{
\itemize{
\item \code{duration_floor()} rounds a duration down to a multiple of the specified
\code{precision}.
\item \code{duration_ceiling()} rounds a duration up to a multiple of the specified
\code{precision}.
\item \code{duration_round()} rounds up or down depending on what is closer,
rounding up on ties.
}
}
\details{
You can floor calendrical durations to other calendrical durations, and
chronological durations to other chronological durations, but you can't
floor a chronological duration to a calendrical duration (such as flooring
from day to month). For more information, see the documentation on the
\link[=duration-helper]{duration helper} page.
}
\examples{
x <- duration_seconds(c(86399, 86401))

duration_floor(x, "day")
duration_ceiling(x, "day")

# Can't floor from a chronological duration (seconds)
# to a calendrical duration (months)
try(duration_floor(x, "month"))

# Every 2 days, using an origin of day 0
y <- duration_seconds(c(0, 86400, 86400 * 2, 86400 * 3))
duration_floor(y, "day", n = 2)

# Shifting the origin to be day 1
origin <- duration_days(1)
duration_floor(y - origin, "day", n = 2) + origin

# Rounding will round ties up
half_day <- 86400 / 2
half_day_durations <- duration_seconds(c(half_day - 1, half_day, half_day + 1))
duration_round(half_day_durations, "day")

# With larger units
x <- duration_months(c(0, 15, 24))
duration_floor(x, "year")
duration_floor(x, "quarter")
}
