% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_int}
\alias{colformat_int}
\title{Format integer cells}
\usage{
colformat_int(
  x,
  i = NULL,
  j = NULL,
  big.mark = get_flextable_defaults()$big.mark,
  na_str = get_flextable_defaults()$na_str,
  nan_str = get_flextable_defaults()$nan_str,
  prefix = "",
  suffix = ""
)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{big.mark}{see \code{\link[=format]{format()}}}

\item{na_str, nan_str}{string to be used for NA and NaN values}

\item{prefix, suffix}{string to be used as prefix or suffix}
}
\description{
Format integer cells in a flextable.
}
\examples{
z <- flextable(head(mtcars))
j <- c("vs", "am", "gear", "carb")
z <- colformat_int(x = z, j = j, prefix = "# ")
z
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_date}()},
\code{\link{colformat_datetime}()},
\code{\link{colformat_double}()},
\code{\link{colformat_image}()},
\code{\link{colformat_lgl}()},
\code{\link{colformat_num}()},
\code{\link{set_formatter}()}
}
\concept{cells formatters}
