% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{font}
\alias{font}
\title{Set font}
\usage{
font(
  x,
  i = NULL,
  j = NULL,
  fontname,
  part = "body",
  cs.family = fontname,
  hansi.family = fontname,
  eastasia.family = fontname
)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{fontname}{single character value, the font family name.
With Word and PowerPoint output, this value specifies the font to
be used for formatting characters in the Unicode range (U+0000-U+007F).}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}

\item{cs.family}{Optional font to be used for formatting
characters in a complex script Unicode range. For example, Arabic
text might be displayed using the "Arial Unicode MS" font.
Used only with Word and PowerPoint outputs. The default value is the value
of \code{fontname}.}

\item{hansi.family}{Optional font to be used for formatting
characters in a Unicode range that does not fall into one of the
other categories.
Used only with Word and PowerPoint outputs. The default value is the value
of \code{fontname}.}

\item{eastasia.family}{Optional font to be used for
formatting characters in an East Asian Unicode range. For example,
Japanese text might be displayed using the "MS Mincho" font.
Used only with Word and PowerPoint outputs. The default value is the value
of \code{fontname}.}
}
\description{
Change the font of selected rows and columns of a flextable.

Fonts impact the readability and aesthetics of the table. Font families
refer to a set of typefaces that share common design features, such as 'Arial'
and 'Open Sans'.

'Google Fonts' is a popular library of free web fonts that can be
easily integrated into flextable with the \code{\link[gdtools:register_gfont]{gdtools::register_gfont()}} function.
When the output is HTML, the font will be automatically added to the HTML
document.
}
\examples{
library(gdtools)
fontname <- "Brush Script MT"

if (font_family_exists(fontname)) {
  ft_1 <- flextable(head(iris))
  ft_2 <- font(ft_1, fontname = fontname, part = "header")
  ft_2 <- font(ft_2, fontname = fontname, j = 5)
  ft_2
}
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{style}()},
\code{\link{tab_settings}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
