% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borders.R
\name{hline_bottom}
\alias{hline_bottom}
\title{Set the bottom border of a table part}
\usage{
hline_bottom(x, j = NULL, border = NULL, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{border}{border properties defined by a call to
\code{\link[officer:fp_border]{officer::fp_border()}}}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
\code{hline_bottom()} draws a horizontal line at the \strong{very bottom}
of a table part. It does not accept a row selector \code{i} because
it always targets the last row.

Unlike \code{\link[=hline]{hline()}}, which adds inner lines below arbitrary rows,
\code{hline_bottom()} is meant for the outer bottom edge of a part.
}
\examples{
library(officer)
big_border <- fp_border(color = "orange", width = 3)

ft <- flextable(head(iris))
ft <- border_remove(x = ft)

# add a thick line at the bottom of the body
ft <- hline_bottom(ft, part = "body", border = big_border)
ft
}
\seealso{
Other borders management: 
\code{\link{border_inner}()},
\code{\link{border_inner_h}()},
\code{\link{border_inner_v}()},
\code{\link{border_outer}()},
\code{\link{border_remove}()},
\code{\link{hline}()},
\code{\link{hline_top}()},
\code{\link{surround}()},
\code{\link{vline}()},
\code{\link{vline_left}()},
\code{\link{vline_right}()}
}
\concept{borders management}
