% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document-api.R
\name{rstudio-editors}
\alias{rstudio-editors}
\alias{getActiveDocumentContext}
\alias{getSourceEditorContext}
\alias{getConsoleEditorContext}
\title{Retrieve Information about an RStudio Editor}
\usage{
getActiveDocumentContext()

getSourceEditorContext(id = NULL)

getConsoleEditorContext()
}
\arguments{
\item{id}{The ID of a particular document, as retrieved by \code{documentId()}
or similar. Supported in RStudio 2022.06.0 or newer.}
}
\value{
A \code{list} with elements:
\tabular{ll}{
\code{id} \tab The document ID.\cr
\code{path} \tab The path to the document on disk.\cr
\code{contents} \tab The contents of the document.\cr
\code{selection} \tab A \code{list} of selections. See \bold{Details} for more information.\cr
}
}
\description{
Returns information about an RStudio editor.
}
\details{
The \code{selection} field returned is a list of document selection objects.
A document selection is just a pairing of a document \code{range}, and the
\code{text} within that range.
}
\note{
The \code{getActiveDocumentContext} function was added with version 0.99.796
of RStudio, while the \code{getSourceEditorContext} and the \code{getConsoleEditorContext}
functions were added with version 0.99.1111.
}
